/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.viritin.grid;

import com.vaadin.data.provider.GridSortOrder;
import com.vaadin.event.SortEvent;
import com.vaadin.server.SerializableSupplier;
import com.vaadin.ui.Grid;
import java.io.Serializable;
import org.vaadin.viritin.grid.MGrid;
import org.vaadin.viritin.grid.SizelessPagingDataCommunicator;

public class LazyGrid<T>
extends MGrid<T> {
    private Grid.FetchItemsCallback<T> fetchItemsCallback;
    private SortEvent.SortListener<GridSortOrder<T>> sortListener = new SortEvent.SortListener<GridSortOrder<T>>(){

        public void sort(SortEvent<GridSortOrder<T>> event) {
            LazyGrid.this.resetContent();
        }
    };

    private void resetContent() {
        this.getDataCommunicator().reset();
        this.setItems(this.fetchItemsCallback);
    }

    public LazyGrid() {
        super(new SizelessPagingDataCommunicator());
    }

    public LazyGrid(Class<T> clazz) {
        super(clazz, new SizelessPagingDataCommunicator());
        this.addSortListener(this.sortListener);
    }

    protected SizelessPagingDataCommunicator<T> getSizelessPagingDataCommunicator() {
        return (SizelessPagingDataCommunicator)this.getDataCommunicator();
    }

    public void setItems(Grid.FetchItemsCallback<T> fetchItems) {
        SerializableSupplier & Serializable sizeCallback = (SerializableSupplier & Serializable)() -> 0;
        this.fetchItemsCallback = fetchItems;
        super.setDataProvider(fetchItems, (SerializableSupplier)sizeCallback);
    }

    public int getPageSize() {
        return this.getSizelessPagingDataCommunicator().getPageSize();
    }

    public void setPageSize(int pageSize) {
        this.getSizelessPagingDataCommunicator().setPageSize(pageSize);
    }
}

