/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model;

import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.schema.Schema;

public class ClientMetaData
extends Profile {
    private static final long serialVersionUID = 1L;
    private transient Schema schema;
    String ipHostNumber;
    String macAddress;
    Location location;

    public String getIpHostNumber() {
        if (null == this.ipHostNumber) {
            return "0.0.0.0";
        }
        return this.ipHostNumber;
    }

    public void setIpHostNumber(String ipHostNumber) {
        String oldIpAddress = this.ipHostNumber;
        this.ipHostNumber = ipHostNumber;
        this.firePropertyChange("ipHostNumber", oldIpAddress, ipHostNumber);
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
        this.firePropertyChange("location", null, location);
    }

    @Override
    protected Class<? extends Profile> getSchemaClass() {
        return Client.class;
    }

    @Override
    public String toString() {
        return String.format("[ClientMetaData %s, MAC=%s, IP=%s]", this.getName(), this.macAddress, this.ipHostNumber);
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        String oldMacAddress = this.macAddress;
        this.macAddress = macAddress.toLowerCase();
        this.firePropertyChange("macAddress", oldMacAddress, macAddress);
    }
}

