/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model.schema.provider;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.AbstractSchemaProvider;
import org.openthinclient.common.model.schema.provider.SchemaLoadingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerLocalSchemaProvider
extends AbstractSchemaProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerLocalSchemaProvider.class);
    private final Path baseDirectory;

    public ServerLocalSchemaProvider(Path baseDirectory) {
        this.baseDirectory = baseDirectory;
    }

    @Override
    protected List<Schema> loadDefaultSchema(String profileTypeName) throws SchemaLoadingException {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        try {
            this.loadFromFile(schemas, this.baseDirectory.resolve(profileTypeName + ".xml"));
        }
        catch (Throwable e) {
            throw new SchemaLoadingException("Could not fetch schema from file service", e);
        }
        return schemas;
    }

    private void loadFromFile(List<Schema> schemas, Path f) throws SchemaLoadingException {
        LOGGER.debug("Trying to load schema from {}", (Object)f);
        if (Files.isRegularFile(f, new LinkOption[0]) && Files.isReadable(f)) {
            try (InputStream in = Files.newInputStream(f, new OpenOption[0]);){
                schemas.add(this.loadSchema(in));
            }
            catch (IOException e) {
                throw new SchemaLoadingException("Schema couldn't be loaded!", e);
            }
        }
    }

    @Override
    protected List<Schema> loadAllSchemas(String profileTypeName) throws SchemaLoadingException {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        try {
            Path dir = this.baseDirectory.resolve(profileTypeName);
            LOGGER.debug("Trying to load all schemas for {} from {}", (Object)profileTypeName, (Object)dir);
            Files.list(dir).filter(f -> Files.isRegularFile(f, new LinkOption[0]) && Files.isReadable(f) && f.getFileName().toString().endsWith(".xml")).forEach(f -> this.loadFromFile((List<Schema>)schemas, (Path)f));
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            LOGGER.debug("No schemas found for " + profileTypeName, (Throwable)e);
        }
        catch (Throwable e) {
            LOGGER.error("Could not fetch schema from file service", e);
            throw new SchemaLoadingException("Could not fetch schema from file service", e);
        }
        return schemas;
    }
}

