/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model.service;

import java.util.Set;
import java.util.stream.Collectors;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.service.AbstractLDAPService;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.ldap.DirectoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLDAPApplicationService
extends AbstractLDAPService<Application>
implements ApplicationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLDAPApplicationService.class);

    public DefaultLDAPApplicationService(RealmService realmService) {
        super(Application.class, realmService);
    }

    @Override
    public void delete(Application application) {
        Realm realm = application.getRealm();
        if (realm == null) {
            throw new IllegalArgumentException("given application has no realm assigned.");
        }
        try {
            realm.getDirectory().delete(application);
        }
        catch (DirectoryException e) {
            throw new RuntimeException("Failed to delete application object", e);
        }
    }

    @Override
    public Set<Application> findAllUsingSchema(Schema schema) {
        long start = System.currentTimeMillis();
        String schemaName = schema.getName();
        Set<Application> collect = this.findAll(Application.class).filter(application -> schemaName.equalsIgnoreCase(this.getSchemaName((Application)application))).collect(Collectors.toSet());
        LOGGER.info("FindAll Application took " + (System.currentTimeMillis() - start) + "ms");
        return collect;
    }

    private String getSchemaName(Application application) {
        Realm realm = application.getRealm();
        Schema schema = application.getSchema(realm);
        return schema.getName();
    }
}

