/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.ldap;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapContext;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.DirectoryFacade;
import org.openthinclient.ldap.Mapping;
import org.openthinclient.ldap.RollbackAction;
import org.openthinclient.ldap.RollbackException;
import org.openthinclient.ldap.SecondLevelCache;
import org.openthinclient.ldap.TypeMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transaction {
    private static final String TYPE_MAPPING_KEY = "####TypeMappingKey####";
    private static final Logger logger = LoggerFactory.getLogger(Transaction.class);
    private final Set processedEntities = new HashSet();
    private final List<RollbackAction> rollbackActions = new LinkedList<RollbackAction>();
    private final Map<Name, Object> cache = new HashMap<Name, Object>();
    private final Mapping mapping;
    private final Map<DirectoryFacade, DirContext> contextCache = new HashMap<DirectoryFacade, DirContext>();
    private final boolean disableGlobalCache;
    boolean isClosed = false;

    public Transaction(Mapping mapping) {
        this(mapping, true);
    }

    public Transaction(Mapping mapping, boolean disableGlobalCache) {
        this.mapping = mapping;
        this.disableGlobalCache = disableGlobalCache;
    }

    public Transaction(Transaction tx) {
        this(tx.mapping, tx.disableGlobalCache);
    }

    public void addEntity(Object entity) {
        this.assertNotClosed();
        this.processedEntities.add(entity);
    }

    public boolean didAlreadyProcessEntity(Object entity) {
        this.assertNotClosed();
        return this.processedEntities.contains(entity);
    }

    public void addRollbackAction(RollbackAction action) {
        this.rollbackActions.add(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws RollbackException {
        this.assertNotClosed();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("ROLLBACK: Need to apply " + this.rollbackActions.size() + " RollbackActions.");
            }
            ListIterator<RollbackAction> i = this.rollbackActions.listIterator(this.rollbackActions.size());
            Throwable firstCause = null;
            while (i.hasPrevious()) {
                try {
                    i.previous().performRollback();
                }
                catch (Throwable e) {
                    if (null != firstCause) {
                        firstCause = e;
                    }
                    logger.error("Exception during Rollback. Trying to continue with rollback anyway.", e);
                }
                if (null == firstCause) continue;
                throw new RollbackException(firstCause);
            }
        }
        finally {
            try {
                this.closeContexts();
            }
            catch (NamingException e) {
                logger.error("Exception during commit - rolling back", (Throwable)e);
            }
        }
    }

    public Object getCacheEntry(Name name) throws Exception {
        Attributes cachedAttributes;
        SecondLevelCache slc;
        this.assertNotClosed();
        Object cached = this.cache.get(name);
        if (null != cached) {
            if (logger.isDebugEnabled()) {
                logger.debug("TX cache hit for " + name);
            }
            return cached;
        }
        if (!this.disableGlobalCache && null != (slc = this.mapping.getSecondLevelCache()) && null != (cachedAttributes = slc.getEntry(name))) {
            Attribute a;
            if (logger.isDebugEnabled()) {
                logger.debug("Global cache hit for " + name);
            }
            if (null == (a = cachedAttributes.get(TYPE_MAPPING_KEY))) {
                logger.error("No type mapping key in cached attributes");
            } else {
                int hashCode = (Integer)a.get();
                cachedAttributes.remove(TYPE_MAPPING_KEY);
                for (TypeMapping m : this.mapping.getMappers()) {
                    if (hashCode != m.hashCode()) continue;
                    Object instance = m.createInstanceFromAttributes(name.toString(), cachedAttributes, this);
                    this.cache.put(name, instance);
                    return instance;
                }
            }
        }
        return null;
    }

    private void assertNotClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("Transaction already closed");
        }
    }

    public void putCacheEntry(TypeMapping m, Name name, Object value, Attributes a) {
        this.assertNotClosed();
        this.cache.put(name, value);
        SecondLevelCache slc = this.mapping.getSecondLevelCache();
        if (null != slc) {
            a.put(TYPE_MAPPING_KEY, m.hashCode());
            slc.putEntry(name, a);
        }
    }

    public void commit() throws RollbackException {
        this.assertNotClosed();
        try {
            this.closeContexts();
        }
        catch (NamingException e) {
            logger.error("Exception during commit - rolling back", (Throwable)e);
            this.rollback();
        }
    }

    private void closeContexts() throws NamingException {
        if (this.contextCache.size() == 0) {
            logger.debug("Closed without having opened a Context");
        }
        for (DirContext ctx : this.contextCache.values()) {
            ctx.close();
        }
        this.contextCache.clear();
        this.isClosed = true;
    }

    protected void finalize() throws Throwable {
        if (this.contextCache.size() > 0) {
            logger.error("Internal error: disposed incompletely closed Transaction");
            this.closeContexts();
        }
        super.finalize();
    }

    public void purgeCacheEntry(Name name) {
        this.assertNotClosed();
        this.cache.remove(name);
        SecondLevelCache slc = this.mapping.getSecondLevelCache();
        if (null != slc) {
            slc.purgeEntry(name);
        }
    }

    public DirContext getContext(DirectoryFacade connectionDescriptor) throws DirectoryException {
        this.assertNotClosed();
        DirContext ctx = this.contextCache.get(connectionDescriptor);
        if (null == ctx) {
            try {
                ctx = this.openContext(connectionDescriptor);
                this.contextCache.put(connectionDescriptor, ctx);
                logger.debug("Created a Context for " + connectionDescriptor);
            }
            catch (NamingException e) {
                throw new DirectoryException("Can't open connection", e);
            }
        }
        return ctx;
    }

    private DirContext openContext(DirectoryFacade connectionDescriptor) throws NamingException {
        final LdapContext ctx = connectionDescriptor.createDirContext();
        if (connectionDescriptor.getLDAPEnv().get("ldap.mapping.single-treaded") != null) {
            return (DirContext)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{DirContext.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Class<Mapping> clazz = Mapping.class;
                    synchronized (Mapping.class) {
                        try {
                            // ** MonitorExit[var4_4] (shouldn't be in output)
                            return method.invoke((Object)ctx, args);
                        }
                        catch (Exception e) {
                            throw e.getCause();
                        }
                    }
                }
            });
        }
        return ctx;
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

