/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.sidebar.config;

import com.vaadin.spring.annotation.UIScope;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.vaadin.spring.i18n.I18N;
import org.vaadin.spring.sidebar.FontAwesomeIconProvider;
import org.vaadin.spring.sidebar.LocalizedThemeIconProvider;
import org.vaadin.spring.sidebar.SideBarUtils;
import org.vaadin.spring.sidebar.ThemeIconProvider;
import org.vaadin.spring.sidebar.VaadinFontIconProvider;
import org.vaadin.spring.sidebar.components.AccordionSideBar;
import org.vaadin.spring.sidebar.components.ValoSideBar;

@Configuration
public class SideBarConfiguration {
    @Autowired
    I18N i18n;
    @Autowired
    ApplicationContext applicationContext;

    @Bean
    @UIScope
    AccordionSideBar accordionSideBar() {
        return new AccordionSideBar(this.sideBarUtils());
    }

    @Bean
    @UIScope
    ValoSideBar valoSideBar() {
        return new ValoSideBar(this.sideBarUtils());
    }

    @Bean
    SideBarUtils sideBarUtils() {
        return new SideBarUtils(this.applicationContext, this.i18n);
    }

    @Bean
    ThemeIconProvider themeIconProvider() {
        return new ThemeIconProvider();
    }

    @Bean
    LocalizedThemeIconProvider localizedThemeIconProvider() {
        return new LocalizedThemeIconProvider(this.i18n);
    }

    @Bean
    FontAwesomeIconProvider fontAwesomeIconProvider() {
        return new FontAwesomeIconProvider();
    }

    @Bean
    VaadinFontIconProvider vaadinFontIconProvider() {
        return new VaadinFontIconProvider();
    }
}

