/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.api.importer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.openthinclient.api.importer.model.ProfileType;

public class ProfileReference {
    private ProfileType type;
    private String name;

    @JsonCreator
    public static ProfileReference parse(String raw) {
        int idx = raw.indexOf(58);
        if (idx != -1) {
            String type = raw.substring(0, idx);
            return new ProfileReference(ProfileType.create(type), raw.substring(idx + 1, raw.length()));
        }
        throw new IllegalArgumentException("Unexpected format. Required format: [TYPE]:[NAME]");
    }

    @Deprecated
    public ProfileReference() {
    }

    public ProfileReference(ProfileType type, String name) {
        this.type = type;
        this.name = name;
    }

    public ProfileType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    @JsonValue
    public String getCompactRepresentation() {
        return this.type.asJsonValue() + ":" + this.name;
    }
}

