/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.api.ldif.export;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.apache.directory.server.tools.ToolCommandListener;
import org.apache.directory.server.tools.commands.exportcmd.ExportCommandExecutor;
import org.apache.directory.server.tools.util.ListenerParameter;
import org.apache.directory.server.tools.util.Parameter;
import org.openthinclient.ldap.LDAPConnectionDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdifExporterService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    static final String BASEDN_REPLACE = "#%BASEDN%#";
    LDAPConnectionDescriptor lcd;

    public LdifExporterService(LDAPConnectionDescriptor ldapConnectionDescriptor) {
        this.lcd = ldapConnectionDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] performAction(Set<String> directoryObjectsDN, final Consumer<State> result) {
        try {
            NameCallback nc = new NameCallback("Bind DN");
            PasswordCallback pc = new PasswordCallback("Password", false);
            this.lcd.getCallbackHandler().handle(new Callback[]{nc, pc});
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            params.add(new Parameter("host", (Object)this.lcd.getHostname()));
            params.add(new Parameter("port", (Object)this.lcd.getPortNumber()));
            switch (this.lcd.getAuthenticationMethod()) {
                case SIMPLE: {
                    params.add(new Parameter("auth", (Object)"simple"));
                    params.add(new Parameter("user", (Object)nc.getName()));
                    params.add(new Parameter("password", (Object)new String(pc.getPassword())));
                }
            }
            params.add(new Parameter("baseDN", (Object)this.lcd.getBaseDN()));
            params.add(new Parameter("scope", (Object)"subtree"));
            params.add(new Parameter("exportPoint", directoryObjectsDN));
            File temp = File.createTempFile("openthinclient-export-", ".ldif");
            params.add(new Parameter("file", (Object)temp.getPath()));
            params.add(new Parameter("debug", (Object)true));
            params.add(new Parameter("verbose", (Object)true));
            ListenerParameter[] listeners = new ListenerParameter[]{new ListenerParameter("exceptionListener", new ToolCommandListener(){

                public void notify(Serializable o) {
                    LdifExporterService.this.log.error("Exception occurred while exporting to ldif-file.", (Object)o);
                    result.accept(State.EXCEPTION);
                }
            }), new ListenerParameter("ouputListener", new ToolCommandListener(){

                public void notify(Serializable o) {
                    result.accept(State.SUCCESS);
                }
            }), new ListenerParameter("errorListener", new ToolCommandListener(){

                public void notify(Serializable o) {
                    LdifExporterService.this.log.error("Error occurred while exporting to ldif-file.", (Object)o);
                    result.accept(State.ERROR);
                }
            })};
            try {
                ExportCommandExecutor ex = new ExportCommandExecutor();
                ex.execute(params.toArray(new Parameter[params.size()]), listeners);
            }
            finally {
                return LdifExporterService.createExportFile(temp, this.lcd.getBaseDN());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static byte[] createExportFile(File tempFile, String dn) throws Exception {
        String strLine;
        FileInputStream fstream = new FileInputStream(tempFile);
        DataInputStream in = new DataInputStream(fstream);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        StringBuffer content = new StringBuffer().append("version: 1").append(System.getProperty("line.separator"));
        Pattern toReplace = Pattern.compile("((^dn:)|(^uniquemember:)|(^l:)) .*" + dn + "$", 2);
        while ((strLine = br.readLine()) != null) {
            Matcher m = toReplace.matcher(strLine);
            if (m.matches()) {
                int pos = strLine.lastIndexOf(dn);
                content.append(strLine.substring(0, pos) + BASEDN_REPLACE).append(System.getProperty("line.separator"));
                continue;
            }
            content.append(strLine).append(System.getProperty("line.separator"));
        }
        in.close();
        tempFile.delete();
        return content.toString().getBytes();
    }

    public String getBaseDN() {
        return this.lcd.getBaseDN();
    }

    public static enum State {
        EXCEPTION,
        ERROR,
        SUCCESS;

    }
}

