/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.tftp;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.service.common.Service;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.tftp.PXEConfigTFTProvider;
import org.openthinclient.tftp.TFTPServiceConfiguration;
import org.openthinclient.tftp.tftpd.FilesystemProvider;
import org.openthinclient.tftp.tftpd.TFTPExport;
import org.openthinclient.tftp.tftpd.TFTPServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TFTPService
implements Service<TFTPServiceConfiguration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TFTPService.class);
    public static final Path DEFAULT_ROOT_PATH = Paths.get("nfs", "root", "tftp");
    private TFTPServer tftpServer;
    private TFTPServiceConfiguration configuration;
    @Autowired
    private ManagerHome managerHome;
    @Autowired
    private RealmService realmService;
    @Autowired
    private ClientService clientService;

    public TFTPServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(TFTPServiceConfiguration configuration) {
        this.configuration = configuration;
    }

    public Class<TFTPServiceConfiguration> getConfigurationClass() {
        return TFTPServiceConfiguration.class;
    }

    public void startService() throws Exception {
        try {
            this.tftpServer = new TFTPServer(0 != this.configuration.getTftpPort() ? this.configuration.getTftpPort() : 69);
            for (TFTPServiceConfiguration.Export export : this.configuration.getExports()) {
                String prefix = export.getPrefix();
                String basedir = export.getBasedir();
                LOGGER.info("Exporting " + prefix + "=" + basedir);
                this.tftpServer.addExport(new TFTPExport(prefix, new FilesystemProvider(basedir)));
            }
            LOGGER.info("Exporting PXE Boot configuration");
            Path tftpHome = this.managerHome.getLocation().toPath().resolve(DEFAULT_ROOT_PATH);
            this.tftpServer.addExport(new TFTPExport("/pxelinux.cfg", new PXEConfigTFTProvider(tftpHome, this.realmService, this.clientService, "template-http.txt", "template-tftp.txt")));
            this.tftpServer.addExport(new TFTPExport("/ipxe.cfg", new PXEConfigTFTProvider(tftpHome, this.realmService, this.clientService, "ipxe.cfg", "ipxe.cfg")));
            this.tftpServer.addExport(new TFTPExport("/localboot.cfg", new PXEConfigTFTProvider(tftpHome, this.realmService, this.clientService, "localboot.cfg", "localboot.cfg")));
            this.tftpServer.start();
            LOGGER.info("TFTP service launched");
        }
        catch (IOException e) {
            LOGGER.error("Exception launching TFTP service", (Throwable)e);
            throw e;
        }
    }

    public void stopService() throws Exception {
        if (null != this.tftpServer) {
            this.tftpServer.shutdown();
            LOGGER.info("TFTP service shut down");
        }
    }
}

