/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.nfsd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.acplt.oncrpc.OncRpcException;
import org.openthinclient.nfsd.NFSFile;
import org.openthinclient.nfsd.PathManager;
import org.openthinclient.nfsd.StaleHandleException;
import org.openthinclient.nfsd.tea.NFSServerStub;
import org.openthinclient.nfsd.tea.attrstat;
import org.openthinclient.nfsd.tea.createargs;
import org.openthinclient.nfsd.tea.dirlist;
import org.openthinclient.nfsd.tea.diropargs;
import org.openthinclient.nfsd.tea.diropokres;
import org.openthinclient.nfsd.tea.diropres;
import org.openthinclient.nfsd.tea.entry;
import org.openthinclient.nfsd.tea.filename;
import org.openthinclient.nfsd.tea.linkargs;
import org.openthinclient.nfsd.tea.nfs_fh;
import org.openthinclient.nfsd.tea.nfscookie;
import org.openthinclient.nfsd.tea.readargs;
import org.openthinclient.nfsd.tea.readdirargs;
import org.openthinclient.nfsd.tea.readdirres;
import org.openthinclient.nfsd.tea.readlinkres;
import org.openthinclient.nfsd.tea.readokres;
import org.openthinclient.nfsd.tea.readres;
import org.openthinclient.nfsd.tea.renameargs;
import org.openthinclient.nfsd.tea.sattrargs;
import org.openthinclient.nfsd.tea.statfsokres;
import org.openthinclient.nfsd.tea.statfsres;
import org.openthinclient.nfsd.tea.symlinkargs;
import org.openthinclient.nfsd.tea.writeargs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NFSServer
extends NFSServerStub {
    static final String SOFTLINK_TAG = ".#%softlink%#";
    static final String COLON_TAG = "#%colon%#";
    private static final Logger LOG = LoggerFactory.getLogger(NFSServer.class);
    private final PathManager pathManager;

    static int byteToInt(byte[] a, int offset) {
        return (a[offset] & 0xFF) << 24 | (a[offset + 1] & 0xFF) << 16 | (a[offset + 2] & 0xFF) << 8 | a[offset + 3] & 0xFF;
    }

    static void intToByte(int i, byte[] a) {
        a[0] = (byte)(i >>> 24 & 0xFF);
        a[1] = (byte)(i >>> 16 & 0xFF);
        a[2] = (byte)(i >>> 8 & 0xFF);
        a[3] = (byte)(i & 0xFF);
    }

    public NFSServer(PathManager pathManager, int port, int programNumber) throws OncRpcException, IOException {
        super(port, programNumber);
        this.pathManager = pathManager;
    }

    @Override
    protected diropres NFSPROC_CREATE_2(createargs params) {
        diropres ret = new diropres();
        try {
            NFSFile dir = this.pathManager.getNFSFileByHandle(params.where.dir);
            if (!dir.getFile().isDirectory()) {
                ret.status = 2;
                return ret;
            }
            String name2 = params.where.name.value;
            File fileToCreate = this.makeFile(name2 = this.replaceColon(name2, false), dir.getFile());
            if (fileToCreate == null) {
                ret.status = 5;
                return ret;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("CREATE: " + fileToCreate);
            }
            if (!fileToCreate.exists()) {
                try {
                    if (!fileToCreate.createNewFile()) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("CREATE: create failed for " + fileToCreate);
                        }
                        ret.status = 5;
                        return ret;
                    }
                }
                catch (SecurityException e) {
                    LOG.warn("CREATE: got exception for " + fileToCreate, (Throwable)e);
                    ret.status = 13;
                    return ret;
                }
                catch (IOException e) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("CREATE: got exception for " + fileToCreate, (Throwable)e);
                    }
                    ret.status = 5;
                    return ret;
                }
            }
            if (ret.status == 0) {
                ret.diropres = new diropokres();
                ret.diropres.file = nfs_fh.NULL_FILE_HANDLE;
                ret.diropres.file = this.pathManager.getHandleByFile(fileToCreate);
                NFSFile file = this.pathManager.getNFSFileByHandle(ret.diropres.file);
                ret.diropres.attributes = file.getAttributes();
            }
        }
        catch (StaleHandleException e) {
            LOG.warn("CREATE: Got stale handle");
            ret.status = 70;
        }
        catch (FileNotFoundException e) {
            ret.status = 2;
        }
        return ret;
    }

    private File makeFile(String name2, File dir) {
        if (name2.indexOf(47) >= 0 || name2.indexOf(92) >= 0) {
            LOG.warn("Got fishy filename: " + name2);
            return null;
        }
        return new File(dir, name2.trim());
    }

    @Override
    protected attrstat NFSPROC_GETATTR_2(nfs_fh params) {
        attrstat ret = new attrstat();
        try {
            NFSFile path = this.pathManager.getNFSFileByHandle(params);
            if (LOG.isDebugEnabled()) {
                LOG.debug("GETATTR: " + path);
            }
            ret.attributes = path.getAttributes();
        }
        catch (StaleHandleException e) {
            LOG.warn("GETATTR: Got stale handle");
            ret.status = 70;
        }
        catch (FileNotFoundException e) {
            ret.status = 2;
        }
        return ret;
    }

    @Override
    protected int NFSPROC_LINK_2(linkargs params) {
        File from = new File("STALE_FILEHANLDE");
        try {
            from = this.pathManager.getNFSFileByHandle(params.from).getFile();
        }
        catch (StaleHandleException e) {
            LOG.warn("LINK: Got stale handle");
            return 70;
        }
        LOG.warn("LINK: not supported: From: " + from + " To: " + params.to.name.value);
        return 13;
    }

    @Override
    protected diropres NFSPROC_LOOKUP_2(diropargs params) {
        diropres ret = new diropres();
        try {
            NFSFile dir = this.pathManager.getNFSFileByHandle(params.dir);
            String name2 = params.name.value;
            name2 = this.replaceColon(name2, false);
            File f = this.makeFile(name2, dir.getFile());
            if (f == null) {
                ret.status = 5;
                return ret;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("LOOKUP: " + f);
            }
            if (!(f = this.checkForLink(name2, dir.getFile(), f)).exists()) {
                ret.status = 2;
            } else {
                ret.diropres = new diropokres();
                ret.diropres.file = this.pathManager.getHandleByFile(f);
                NFSFile file = this.pathManager.getNFSFileByHandle(ret.diropres.file);
                ret.diropres.attributes = file.getAttributes();
            }
        }
        catch (StaleHandleException e) {
            LOG.warn("LOOKUP: Got stale handle");
            ret.status = 70;
        }
        catch (FileNotFoundException e) {
            ret.status = 2;
        }
        return ret;
    }

    private File checkForLink(String name2, File dir, File f) {
        File link;
        if (!f.exists() && (link = new File(dir, name2 + SOFTLINK_TAG)).exists()) {
            f = link;
        }
        return f;
    }

    private String replaceColon(String name2, boolean revert) {
        if (!revert) {
            if (name2.contains(":")) {
                name2 = name2.replace(":", COLON_TAG);
            }
        } else if (name2.contains(COLON_TAG)) {
            name2 = name2.replace(COLON_TAG, ":");
        }
        return name2;
    }

    @Override
    protected diropres NFSPROC_MKDIR_2(createargs params) {
        diropres ret = new diropres();
        try {
            NFSFile dir = this.pathManager.getNFSFileByHandle(params.where.dir);
            String name2 = params.where.name.value;
            name2 = this.replaceColon(name2, false);
            File dirToCreate = this.makeFile(name2, dir.getFile());
            if (dirToCreate == null) {
                ret.status = 5;
                return ret;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("MKDIR: " + dirToCreate);
            }
            if (dirToCreate.exists()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("MKDIR: directory exists " + dirToCreate);
                }
                ret.status = 17;
                return ret;
            }
            try {
                if (!dirToCreate.mkdir()) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("MKDIR: mkdir failed for " + dirToCreate);
                    }
                    ret.status = 5;
                    return ret;
                }
            }
            catch (SecurityException e) {
                LOG.warn("MKDIR: got exception for " + dirToCreate, (Throwable)e);
                ret.status = 13;
                return ret;
            }
            ret.diropres = new diropokres();
            ret.diropres.file = this.pathManager.getHandleByFile(dirToCreate);
            if (ret.status == 0) {
                NFSFile newdir = this.pathManager.getNFSFileByHandle(ret.diropres.file);
                ret.diropres.attributes = newdir.getAttributes();
            }
        }
        catch (StaleHandleException e1) {
            LOG.warn("MKDIR: Got stale handle");
            ret.status = 70;
        }
        catch (FileNotFoundException e) {
            ret.status = 2;
        }
        return ret;
    }

    @Override
    protected void NFSPROC_NULL_2() {
        LOG.debug("NULL");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected readres NFSPROC_READ_2(readargs params) {
        readres ret = new readres();
        try {
            NFSFile f = this.pathManager.getNFSFileByHandle(params.file);
            int offset = params.offset;
            int count = Math.min(8192, params.count);
            ret.reply = new readokres();
            ret.reply.data = new byte[count];
            if (LOG.isDebugEnabled()) {
                LOG.debug("READ: " + f + "," + count + " bytes " + offset + " offset");
            }
            ret.reply.attributes = f.getAttributes();
            if (f.getFile().isDirectory()) {
                ret.status = 21;
                if (!LOG.isInfoEnabled()) return ret;
                LOG.info("READ: attempt to read from drectory");
                return ret;
            }
            try {
                FileChannel c = f.getChannel(false);
                ByteBuffer b = ByteBuffer.wrap(ret.reply.data);
                int total = 0;
                int read = 0;
                do {
                    read = c.read(b, offset + total);
                    if (read <= 0) return ret;
                } while ((total += read) < count);
                return ret;
            }
            catch (SecurityException e) {
                LOG.warn("READ: got exception for " + f, (Throwable)e);
                ret.status = 13;
                return ret;
            }
            catch (IOException e) {
                LOG.warn("READ: got exception for " + f, (Throwable)e);
                ret.status = 5;
            }
            return ret;
        }
        catch (StaleHandleException e1) {
            LOG.warn("READ: Got stale handle");
            ret.status = 70;
            return ret;
        }
        catch (FileNotFoundException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info("READ: the file has vanished.", (Throwable)e);
            }
            ret.status = 2;
        }
        return ret;
    }

    @Override
    protected readdirres NFSPROC_READDIR_2(readdirargs params) {
        readdirres ret = new readdirres();
        try {
            NFSFile dir = this.pathManager.getNFSFileByHandle(params.dir);
            if (LOG.isDebugEnabled()) {
                LOG.debug("READDIR: " + dir);
            }
            int cookie = NFSServer.byteToInt(params.cookie.value, 0);
            int size = 8;
            entry curr = null;
            ret.reply = new dirlist();
            ret.reply.entries = null;
            ret.reply.eof = false;
            try {
                File[] dirlist2 = dir.getFile().listFiles();
                TreeMap<Integer, File> dirMapFileById = new TreeMap<Integer, File>();
                for (int i = 0; i < dirlist2.length; ++i) {
                    dirMapFileById.put(this.pathManager.getIDByFile(dirlist2[i]), dirlist2[i]);
                }
                int[] tmpArray = new int[dirlist2.length];
                int n = 0;
                Iterator i = dirMapFileById.keySet().iterator();
                while (i.hasNext()) {
                    tmpArray[n] = (Integer)i.next();
                    ++n;
                }
                HashMap<Integer, Integer> idMapNextByCurrent = new HashMap<Integer, Integer>();
                for (int i2 = 0; i2 < tmpArray.length; ++i2) {
                    if (i2 + 1 < tmpArray.length) {
                        idMapNextByCurrent.put(tmpArray[i2], tmpArray[i2 + 1]);
                        continue;
                    }
                    idMapNextByCurrent.put(tmpArray[i2], Integer.MAX_VALUE);
                }
                Iterator i3 = dirMapFileById.entrySet().iterator();
                while (i3.hasNext()) {
                    entry next = new entry();
                    Map.Entry pairs = i3.next();
                    File f = (File)pairs.getValue();
                    String fileName = f.getName();
                    Integer fileId = (Integer)pairs.getKey();
                    if (fileId < cookie) continue;
                    next.fileid = this.pathManager.getIDByFile(f);
                    if (fileName.endsWith(SOFTLINK_TAG)) {
                        fileName = fileName.substring(0, fileName.length() - SOFTLINK_TAG.length());
                    }
                    fileName = this.replaceColon(fileName, true);
                    next.name = new filename(fileName);
                    next.cookie = new nfscookie(new byte[4]);
                    NFSServer.intToByte((Integer)idMapNextByCurrent.get(fileId), next.cookie.value);
                    if ((size += 8 + next.name.value.length() + (4 - next.name.value.length() % 4) % 4 + 4 + 4) + 4 > params.count) {
                        ret.reply.eof = false;
                        return ret;
                    }
                    if (ret.reply.entries == null) {
                        ret.reply.entries = next;
                    } else {
                        curr.nextentry = next;
                    }
                    curr = next;
                }
                ret.reply.eof = true;
            }
            catch (SecurityException e) {
                LOG.warn("READDIR: got exception for " + dir, (Throwable)e);
                ret.status = 13;
            }
        }
        catch (StaleHandleException e1) {
            LOG.warn("READDIR: Got stale handle");
            ret.status = 70;
        }
        return ret;
    }

    @Override
    protected readlinkres NFSPROC_READLINK_2(nfs_fh params) {
        readlinkres ret = new readlinkres();
        try {
            NFSFile f = this.pathManager.getNFSFileByHandle(params);
            try {
                ret.data = f.getLinkDestination();
            }
            catch (SecurityException e) {
                LOG.warn("READ: got exception for " + f, (Throwable)e);
                ret.status = 13;
            }
            catch (IOException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("READ: got exception for " + f, (Throwable)e);
                }
                ret.status = 5;
            }
        }
        catch (StaleHandleException e1) {
            LOG.warn("READLINK: Got stale handle");
            ret.status = 70;
        }
        return ret;
    }

    @Override
    protected int NFSPROC_REMOVE_2(diropargs params) {
        try {
            NFSFile dir = this.pathManager.getNFSFileByHandle(params.dir);
            String name2 = params.name.value.trim();
            name2 = this.replaceColon(name2, false);
            File f = this.makeFile(name2, dir.getFile());
            if (f == null) {
                return 5;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("REMOVE: " + f);
            }
            if (!(f = this.checkForLink(name2, dir.getFile(), f)).exists()) {
                return 2;
            }
            try {
                this.pathManager.flushFile(f);
                if (!f.delete()) {
                    LOG.warn("REMOVE: remove failed for " + f);
                    return 5;
                }
            }
            catch (SecurityException e) {
                LOG.warn("REMOVE: got exception for " + f, (Throwable)e);
                return 13;
            }
            this.pathManager.purgeFileAndHandle(f);
        }
        catch (StaleHandleException e1) {
            LOG.warn("REMOVE: Got stale handle");
            return 70;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int NFSPROC_RENAME_2(renameargs params) {
        NFSServer nFSServer = this;
        synchronized (nFSServer) {
            try {
                NFSFile fromdir = this.pathManager.getNFSFileByHandle(params.from.dir);
                NFSFile todir = this.pathManager.getNFSFileByHandle(params.to.dir);
                String fromName = params.from.name.value;
                String toName = params.to.name.value;
                fromName = this.replaceColon(fromName, false);
                toName = this.replaceColon(toName, false);
                File from = this.makeFile(fromName, fromdir.getFile());
                File to = this.makeFile(toName, todir.getFile());
                if (from == null) return 5;
                if (to == null) {
                    return 5;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("RENAME: " + from + " to " + to);
                }
                if ((from = this.checkForLink(from.getName(), from.getParentFile(), from)).getName().endsWith(SOFTLINK_TAG)) {
                    to = this.makeFile(to.getName() + SOFTLINK_TAG, to.getParentFile());
                }
                File toCheckLink = to;
                if (!to.getName().endsWith(SOFTLINK_TAG)) {
                    toCheckLink = this.checkForLink(to.getName(), to.getParentFile(), to);
                }
                File renameTemp = new File(to.getName() + ".#RENAMETEMP#");
                try {
                    this.pathManager.flushFile(from);
                    this.pathManager.flushFile(to);
                    if (to.isFile() && to.exists() && !to.renameTo(renameTemp)) {
                        LOG.warn("RENAME: rename failed for " + renameTemp);
                        int n = 5;
                        return n;
                    }
                    if (!from.renameTo(to)) {
                        LOG.warn("RENAME: rename failed for " + from + " to " + to);
                        int n = 5;
                        return n;
                    }
                    this.pathManager.movePath(from, to);
                    if (to.equals(toCheckLink)) return 0;
                    this.pathManager.flushFile(toCheckLink);
                    if (!toCheckLink.delete()) {
                        LOG.warn("RENAME: deleting failed for link " + toCheckLink);
                        int n = 5;
                        return n;
                    }
                    this.pathManager.purgeFileAndHandle(toCheckLink);
                }
                catch (SecurityException e) {
                    int n = 13;
                    return n;
                }
                catch (Exception e) {
                    int n = 5;
                    return n;
                }
                finally {
                    if (renameTemp.isFile() && renameTemp.exists()) {
                        this.pathManager.flushFile(renameTemp);
                        if (!renameTemp.delete()) {
                            LOG.warn("RENAME: deleting failed for " + renameTemp);
                        }
                    }
                }
            }
            catch (StaleHandleException e1) {
                LOG.warn("RENAME: got stale handle");
                return 70;
            }
            return 0;
        }
    }

    @Override
    protected int NFSPROC_RMDIR_2(diropargs params) {
        return this.NFSPROC_REMOVE_2(params);
    }

    @Override
    protected void NFSPROC_ROOT_2() {
        LOG.debug("ROOT");
    }

    @Override
    protected attrstat NFSPROC_SETATTR_2(sattrargs params) {
        attrstat ret = new attrstat();
        try {
            NFSFile f = this.pathManager.getNFSFileByHandle(params.file);
            if (LOG.isDebugEnabled()) {
                LOG.debug("SETATTR: " + f);
            }
            ret.attributes = f.getAttributes();
            try {
                if (f.getAttributes().size != params.attributes.size && params.attributes.size != -1) {
                    try {
                        FileChannel c = f.getChannel(true);
                        long current = c.size();
                        if (current < (long)params.attributes.size) {
                            c.position(params.attributes.size - 1);
                            c.write(ByteBuffer.allocate(1));
                        } else {
                            c.truncate(params.attributes.size);
                        }
                        f.flushCachedAttributes();
                    }
                    catch (SecurityException e) {
                        LOG.warn("READ: got exception for " + f, (Throwable)e);
                        ret.status = 13;
                    }
                    catch (IOException e) {
                        LOG.warn("READ: got exception for " + f, (Throwable)e);
                        ret.status = 5;
                    }
                }
            }
            catch (SecurityException e) {
                LOG.warn("SETATTR: got exception for " + f, (Throwable)e);
                ret.status = 13;
                return ret;
            }
        }
        catch (StaleHandleException e1) {
            LOG.warn("SETATTR: got stale handle");
            ret.status = 70;
        }
        catch (FileNotFoundException e) {
            ret.status = 2;
        }
        return ret;
    }

    @Override
    protected statfsres NFSPROC_STATFS_2(nfs_fh params) {
        statfsres ret = new statfsres();
        LOG.debug("STATFS");
        ret.reply = new statfsokres();
        ret.reply.tsize = 8192;
        ret.reply.bsize = 8192;
        ret.reply.blocks = 100100;
        ret.reply.bfree = 100000;
        ret.reply.bavail = 100000;
        return ret;
    }

    @Override
    protected int NFSPROC_SYMLINK_2(symlinkargs params) {
        try {
            NFSFile fromdir = this.pathManager.getNFSFileByHandle(params.from.dir);
            String dest = params.to.value;
            dest = this.replaceColon(dest, false);
            String fromName = params.from.name.value.trim();
            fromName = this.replaceColon(fromName, false);
            File from = this.makeFile(fromName + SOFTLINK_TAG, fromdir.getFile());
            if (null == from) {
                return 5;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("SYMLINK: " + from + " to " + dest);
            }
            if (from.exists()) {
                LOG.info("SYMLINK: file exists " + from);
                return 17;
            }
            try {
                FileWriter w = new FileWriter(from);
                w.write(dest);
                w.close();
            }
            catch (SecurityException e) {
                return 13;
            }
            catch (IOException e) {
                return 5;
            }
        }
        catch (StaleHandleException e1) {
            LOG.warn("SYMLINK: got stale handle");
            return 70;
        }
        return 0;
    }

    @Override
    protected attrstat NFSPROC_WRITE_2(writeargs params) {
        attrstat ret = new attrstat();
        ret.status = 0;
        int count = params.data.length;
        int offset = params.offset;
        try {
            NFSFile f = this.pathManager.getNFSFileByHandle(params.file);
            if (LOG.isDebugEnabled()) {
                LOG.debug("WRITE: " + f + " of " + count + " bytes");
            }
            if (f.getFile().isDirectory()) {
                ret.status = 21;
                return ret;
            }
            ret.attributes = f.getAttributes();
            f.flushCachedAttributes();
            try {
                FileChannel c = f.getChannel(true);
                c.write(ByteBuffer.wrap(params.data, 0, count), offset);
            }
            catch (SecurityException e) {
                LOG.warn("WRITE: got exception for " + f, (Throwable)e);
                ret.status = 13;
            }
            catch (IOException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("WRITE: got exception for " + f, (Throwable)e);
                }
                ret.status = 5;
            }
        }
        catch (StaleHandleException e1) {
            LOG.warn("WRITE: got stale handle");
            ret.status = 70;
        }
        catch (FileNotFoundException e) {
            ret.status = 2;
        }
        return ret;
    }

    @Override
    protected void NFSPROC_WRITECACHE_2() {
        LOG.warn("WRITECACHE: not implemented");
    }
}

