/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.security;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.RememberMeAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.authentication.NullRememberMeServices;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.util.Assert;
import org.vaadin.spring.security.VaadinSecurity;

public abstract class AbstractVaadinSecurity
implements ApplicationContextAware,
InitializingBean,
VaadinSecurity {
    private static final Logger logger = LoggerFactory.getLogger(AbstractVaadinSecurity.class);
    private ApplicationContext applicationContext;
    private AuthenticationManager authenticationManager;
    private AccessDecisionManager accessDecisionManager;
    private RememberMeServices rememberMeServices;

    @Override
    public boolean isAuthenticated() {
        Authentication authentication = this.getAuthentication();
        return authentication != null && authentication.isAuthenticated() && !(authentication instanceof AnonymousAuthenticationToken);
    }

    @Override
    public boolean isAuthenticatedAnonymously() {
        Authentication authentication = this.getAuthentication();
        return authentication instanceof AnonymousAuthenticationToken && authentication.isAuthenticated();
    }

    @Override
    public boolean isRememberMeAuthenticated() {
        Authentication authentication = this.getAuthentication();
        return authentication instanceof RememberMeAuthenticationToken && authentication.isAuthenticated();
    }

    @Override
    public boolean isFullyAuthenticated() {
        Authentication authentication = this.getAuthentication();
        return authentication != null && !(authentication instanceof AnonymousAuthenticationToken) && !(authentication instanceof RememberMeAuthenticationToken) && authentication.isAuthenticated();
    }

    @Override
    public Authentication login(String username, String password) throws AuthenticationException, Exception {
        return this.login((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.authenticationManager = (AuthenticationManager)this.applicationContext.getBean(AuthenticationManager.class);
            logger.info("Using authentication manager {}", (Object)this.authenticationManager);
        }
        catch (NoSuchBeanDefinitionException ex) {
            logger.warn("No AuthenticationManager found! Some security methods will not be available.");
        }
        try {
            this.accessDecisionManager = (AccessDecisionManager)this.applicationContext.getBean(AccessDecisionManager.class);
            logger.info("Using access decision manager {}", (Object)this.accessDecisionManager);
        }
        catch (NoSuchBeanDefinitionException ex) {
            this.accessDecisionManager = null;
            logger.warn("No AccessDecisionManager found! Some security methods will not be available.");
        }
        try {
            this.rememberMeServices = (RememberMeServices)this.applicationContext.getBean(RememberMeServices.class);
            logger.info("Using RememberMeServices {}", (Object)this.rememberMeServices);
        }
        catch (NoSuchBeanDefinitionException ex) {
            this.rememberMeServices = new NullRememberMeServices();
            logger.info("No RememberMeServices found. Using NullRememberMeServices.");
        }
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    @Override
    public AccessDecisionManager getAccessDecisionManager() {
        return this.accessDecisionManager;
    }

    @Override
    public boolean hasAccessDecisionManager() {
        return this.accessDecisionManager != null;
    }

    @Override
    public boolean hasAuthenticationManager() {
        return this.authenticationManager != null;
    }

    @Override
    public RememberMeServices getRememberMeServices() {
        return this.rememberMeServices;
    }

    @Override
    public boolean hasAuthority(String authority) {
        Authentication authentication = this.getAuthentication();
        if (authentication == null || !authentication.isAuthenticated()) {
            return false;
        }
        for (GrantedAuthority grantedAuthority : authentication.getAuthorities()) {
            if (!authority.equals(grantedAuthority.getAuthority())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAuthorities(String ... authorities) {
        for (String authority : authorities) {
            if (this.hasAuthority(authority)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasAnyAuthority(String ... authorities) {
        for (String authority : authorities) {
            if (!this.hasAuthority(authority)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasAccessToObject(Object securedObject, String ... securityConfigurationAttributes) {
        Authentication authentication = this.getAuthentication();
        if (this.getAccessDecisionManager() == null) {
            logger.warn("Access was denied to object because there was no AccessDecisionManager set!");
            return false;
        }
        if (authentication == null || !authentication.isAuthenticated()) {
            return false;
        }
        ArrayList<SecurityConfig> configAttributes = new ArrayList<SecurityConfig>(securityConfigurationAttributes.length);
        for (String securityConfigString : securityConfigurationAttributes) {
            configAttributes.add(new SecurityConfig(securityConfigString));
        }
        try {
            this.getAccessDecisionManager().decide(authentication, securedObject, configAttributes);
            return true;
        }
        catch (AccessDeniedException ex) {
            logger.trace("Access denied when accessing {}", securedObject);
            return false;
        }
        catch (InsufficientAuthenticationException ex) {
            logger.trace("Insufficient authentication when accessing {}", securedObject);
            return false;
        }
    }

    @Override
    public boolean hasAccessToSecuredObject(Object securedObject) {
        Secured secured = AopUtils.getTargetClass((Object)securedObject).getAnnotation(Secured.class);
        Assert.notNull((Object)secured, (String)"securedObject did not have @Secured annotation");
        return this.hasAccessToObject(securedObject, secured.value());
    }

    @Override
    public boolean hasAccessToSecuredMethod(Object securedObject, String methodName, Class<?> ... methodParameterTypes) {
        try {
            Method method = securedObject.getClass().getMethod(methodName, methodParameterTypes);
            Secured secured = (Secured)AnnotationUtils.findAnnotation((Method)method, Secured.class);
            Assert.notNull((Object)secured, (String)"securedObject did not have @Secured annotation");
            return this.hasAccessToObject(securedObject, secured.value());
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Method " + methodName + " does not exist", ex);
        }
    }
}

