/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.security.managed;

import com.vaadin.server.Page;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinSession;
import com.vaadin.server.WrappedSession;
import com.vaadin.shared.ui.ui.Transport;
import com.vaadin.ui.UI;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.vaadin.spring.security.AbstractVaadinSecurity;
import org.vaadin.spring.security.managed.VaadinManagedSecurity;

public class DefaultVaadinManagedSecurity
extends AbstractVaadinSecurity
implements VaadinManagedSecurity {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultVaadinManagedSecurity.class);
    public static final String REINITIALIZE_SESSION_AFTER_LOGIN_PROPERTY = "vaadin.spring.security.managed.reinitialize-session-after-login";

    public DefaultVaadinManagedSecurity() {
        LOGGER.info("Using Vaadin Managed Security");
    }

    protected boolean isReinitializeSessionAfterLogin() {
        return (Boolean)this.getApplicationContext().getEnvironment().getProperty(REINITIALIZE_SESSION_AFTER_LOGIN_PROPERTY, Boolean.class, (Object)true);
    }

    @Override
    public Authentication login(Authentication authentication) throws AuthenticationException {
        LOGGER.debug("Authenticating using {}", (Object)authentication);
        Authentication fullyAuthenticated = this.getAuthenticationManager().authenticate(authentication);
        if (this.isReinitializeSessionAfterLogin()) {
            this.clearAndReinitializeSession();
        }
        SecurityContext context = SecurityContextHolder.getContext();
        LOGGER.debug("Setting authentication of context {} to {}", (Object)context, (Object)fullyAuthenticated);
        context.setAuthentication(fullyAuthenticated);
        return fullyAuthenticated;
    }

    protected void clearAndReinitializeSession() {
        Transport transport;
        VaadinRequest currentRequest = VaadinService.getCurrentRequest();
        UI currentUI = UI.getCurrent();
        if (currentUI != null && (Transport.WEBSOCKET.equals((Object)(transport = currentUI.getPushConfiguration().getTransport())) || Transport.WEBSOCKET_XHR.equals((Object)transport))) {
            LOGGER.warn("Clearing and reinitializing the session is currently not supported when using Websocket Push.");
            return;
        }
        if (currentRequest != null) {
            LOGGER.debug("Clearing the session");
            WrappedSession session = currentRequest.getWrappedSession();
            String serviceName = VaadinService.getCurrent().getServiceName();
            HashSet<String> attributesToSpare = new HashSet<String>();
            attributesToSpare.add(serviceName + ".lock");
            attributesToSpare.add(VaadinSession.class.getName() + "." + serviceName);
            for (String s : currentRequest.getWrappedSession().getAttributeNames()) {
                if (attributesToSpare.contains(s)) continue;
                LOGGER.trace("Removing attribute {} from session", (Object)s);
                session.removeAttribute(s);
            }
            LOGGER.debug("Reinitializing the session {}", (Object)session.getId());
            VaadinService.reinitializeSession((VaadinRequest)currentRequest);
            LOGGER.debug("Session reinitialized, new ID is {}", (Object)VaadinService.getCurrentRequest().getWrappedSession().getId());
        } else {
            LOGGER.warn("No VaadinRequest bound to current thread, could NOT clear/reinitialize the session after login");
        }
    }

    @Override
    public void logout() {
        VaadinSession.getCurrent().close();
        Page.getCurrent().reload();
    }

    @Override
    public void logout(String logoutUrl) {
        VaadinSession.getCurrent().close();
        Page.getCurrent().setLocation(logoutUrl);
    }

    @Override
    public Authentication getAuthentication() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        return securityContext.getAuthentication();
    }
}

