/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.security.shared;

import com.vaadin.server.VaadinSession;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;

public class VaadinSessionClosingLogoutHandler
implements LogoutHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(VaadinSessionClosingLogoutHandler.class);

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        try {
            LOGGER.debug("Logging out and closing all Vaadin sessions");
            Collection allSessions = VaadinSession.getAllSessions((HttpSession)request.getSession());
            for (VaadinSession session : allSessions) {
                LOGGER.debug("Closing session [{}]", (Object)session);
                session.close();
            }
        }
        catch (Exception ex) {
            LOGGER.error("An exception occurred while attempting to close the Vaadin sessions", (Throwable)ex);
        }
    }
}

