/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.sysreport.generate;

import java.time.Duration;
import java.time.LocalDateTime;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.sysreport.AbstractReport;
import org.openthinclient.sysreport.Source;
import org.openthinclient.sysreport.generate.ReportContributor;

public abstract class AbstractPackageManagerReportContributor<T extends AbstractReport>
implements ReportContributor<T> {
    protected final PackageManager packageManager;

    public AbstractPackageManagerReportContributor(PackageManager packageManager) {
        this.packageManager = packageManager;
    }

    @Override
    public void contribute(T report) {
        ((AbstractReport)report).getServer().setFreeDiskSpace(this.packageManager.getFreeDiskSpace() * 1024L);
        this.packageManager.getInstalledPackages().forEach(pkg -> this.onInstalled(report, (Package)pkg));
        this.packageManager.getInstallablePackages().forEach(pkg -> this.onInstallable(report, (Package)pkg));
        this.packageManager.getSourcesList().getSources().forEach(source -> this.onSource(report, (org.openthinclient.pkgmgr.db.Source)source));
    }

    protected void onSource(T report, org.openthinclient.pkgmgr.db.Source source) {
    }

    protected void onInstallable(T report, Package aPackage) {
    }

    protected void onInstalled(T report, Package aPackage) {
    }

    protected Source convert(org.openthinclient.pkgmgr.db.Source source) {
        Source converted = new Source();
        converted.setEnabled(source.isEnabled());
        converted.setLastUpdated(source.getLastUpdated());
        if (source.getLastUpdated() != null) {
            converted.setTimeSinceLastUpdate(Duration.between(source.getLastUpdated(), LocalDateTime.now()));
        }
        converted.setUrl(source.getUrl());
        return converted;
    }
}

