/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.sysreport.generate;

import java.util.ArrayList;
import java.util.List;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.sysreport.AbstractReport;
import org.openthinclient.sysreport.generate.ManagerReportContributor;
import org.openthinclient.sysreport.generate.ReportContributor;
import org.openthinclient.sysreport.generate.ServerReportContributor;

public abstract class AbstractReportGenerator<T extends AbstractReport> {
    protected final List<ReportContributor<? super T>> contributors = new ArrayList<ReportContributor<? super T>>();

    public AbstractReportGenerator(ManagerHome managerHome) {
        this.contributors.add(new ServerReportContributor(managerHome));
        this.contributors.add(new ManagerReportContributor());
    }

    public List<ReportContributor<? super T>> getContributors() {
        return this.contributors;
    }

    protected abstract T createReportInstance();

    public T generateReport() {
        T report = this.createReportInstance();
        for (ReportContributor<T> contributor : this.contributors) {
            contributor.contribute(report);
        }
        return report;
    }
}

