/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.sysreport.generate;

import com.google.common.primitives.Bytes;
import java.util.stream.Collectors;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.sysreport.SystemReport;
import org.openthinclient.sysreport.generate.AbstractReportGenerator;
import org.openthinclient.sysreport.generate.NetworkInterfaceDetailsContributor;
import org.openthinclient.sysreport.generate.PackageManagerReportContributor;

public class SystemReportGenerator
extends AbstractReportGenerator<SystemReport> {
    public SystemReportGenerator(ManagerHome managerHome, PackageManager packageManager) {
        super(managerHome);
        this.contributors.add(new NetworkInterfaceDetailsContributor());
        this.contributors.add(new PackageManagerReportContributor(packageManager));
    }

    @Override
    public SystemReport generateReport() {
        SystemReport report = (SystemReport)super.generateReport();
        report.getSubmitter().setSubmitterType(SystemReport.SubmitterType.AUTOMATED);
        report.getSubmitter().setName("openthinclient.org Manager, Report Generator");
        return report;
    }

    @Override
    protected SystemReport createReportInstance() {
        return new SystemReport();
    }

    public static String toMacAddressString(byte[] address) {
        return Bytes.asList((byte[])address).stream().map(b -> String.format("%02x", b)).collect(Collectors.joining(":"));
    }
}

