/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.check;

import ch.qos.cal10n.MessageConveyor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.openthinclient.manager.util.installation.InstallationDirectoryUtil;
import org.openthinclient.wizard.AdvisorMessages;
import org.openthinclient.wizard.check.AbstractCheck;
import org.openthinclient.wizard.check.CheckExecutionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckManagerHomeDirectory
extends AbstractCheck<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(CheckManagerHomeDirectory.class);
    private final File directory;

    public CheckManagerHomeDirectory(Locale locale, File directory) {
        super(new MessageConveyor(locale).getMessage((Enum)AdvisorMessages.ADVISOR_CHECKMANAGERHOMEDIRECTORY_TITLE, new Object[0]), new MessageConveyor(locale).getMessage((Enum)AdvisorMessages.ADVISOR_CHECKMANAGERHOMEDIRECTORY_DESCRIPTION, new Object[0]));
        if (directory == null) {
            throw new IllegalArgumentException("directory must not be null");
        }
        this.directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CheckExecutionResult<Boolean> perform() {
        LOG.info("checking manager home directory '{}'", (Object)this.directory);
        if (this.directory.exists()) {
            if (!this.directory.isDirectory()) {
                return new CheckExecutionResult<Boolean>(CheckExecutionResult.CheckResultType.FAILED, false);
            }
            if (!InstallationDirectoryUtil.isInstallationDirectoryEmpty((File)this.directory, (boolean)true)) {
                return new CheckExecutionResult<Boolean>(CheckExecutionResult.CheckResultType.FAILED, false);
            }
        } else if (!this.directory.mkdirs()) {
            return new CheckExecutionResult<Boolean>(CheckExecutionResult.CheckResultType.FAILED, false);
        }
        File targetFile = new File(this.directory, "test.txt");
        try (FileOutputStream out = new FileOutputStream(targetFile);){
            ((OutputStream)out).write("TEST".getBytes());
        }
        catch (Exception e) {
            LOG.info("Creating a test file in the directory '{}' failed", (Object)this.directory);
            LOG.info("Failure reason.", (Throwable)e);
            CheckExecutionResult<Boolean> checkExecutionResult = new CheckExecutionResult<Boolean>(CheckExecutionResult.CheckResultType.FAILED, false);
            return checkExecutionResult;
        }
        finally {
            targetFile.delete();
        }
        return new CheckExecutionResult<Boolean>(CheckExecutionResult.CheckResultType.SUCCESS, true);
    }
}

