/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.install;

import java.nio.file.Path;
import org.openthinclient.api.context.InstallContext;
import org.openthinclient.manager.util.installation.InstallationDirectoryUtil;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.install.AbstractInstallStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;

public class FinalizeInstallationStep
extends AbstractInstallStep {
    private final Logger LOG = LoggerFactory.getLogger(FinalizeInstallationStep.class);

    @Override
    protected void doExecute(InstallContext installContext) throws Exception {
        PackageManager pm = installContext.getPackageManager();
        if (pm != null) {
            this.LOG.info("Closing package manager instance");
            pm.close();
        }
        InstallationDirectoryUtil.removeInstallationFile((Path)installContext.getManagerHome().getLocation().toPath());
        ConfigurableApplicationContext context = installContext.getContext();
        if (context != null) {
            this.LOG.info("Closing temporary application context");
            context.close();
        }
    }

    @Override
    public String getName() {
        return this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALL_FINALIZEINSTALLATIONSTEP_LABEL, new Object[0]);
    }

    @Override
    public double getProgress() {
        return 1.0;
    }
}

