/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.install;

import java.io.File;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.openthinclient.api.context.InstallContext;
import org.openthinclient.api.distributions.ImportableProfileProvider;
import org.openthinclient.api.distributions.InstallableDistribution;
import org.openthinclient.manager.util.installation.InstallationDirectoryUtil;
import org.openthinclient.service.common.home.impl.ManagerHomeFactory;
import org.openthinclient.wizard.install.AbstractInstallStep;
import org.openthinclient.wizard.install.BootstrapLDAPInstallStep;
import org.openthinclient.wizard.install.ConfigureNFSInstallStep;
import org.openthinclient.wizard.install.ConfigureSyslogInstallStep;
import org.openthinclient.wizard.install.ConfigureTFTPInstallStep;
import org.openthinclient.wizard.install.FinalizeInstallationStep;
import org.openthinclient.wizard.install.InstallState;
import org.openthinclient.wizard.install.PackageManagerUpdatedPackageListInstallStep;
import org.openthinclient.wizard.install.PrepareDatabaseInstallStep;
import org.openthinclient.wizard.install.PrepareManagerHomeInstallStep;
import org.openthinclient.wizard.install.RequiredPackagesInstallStep;
import org.openthinclient.wizard.model.DatabaseModel;
import org.openthinclient.wizard.model.DirectoryModel;
import org.openthinclient.wizard.model.NetworkConfigurationModel;

public class InstallSystemTask
implements Callable<Boolean> {
    private final List<AbstractInstallStep> steps;
    private volatile InstallState installState = InstallState.PENDING;

    public InstallSystemTask(ManagerHomeFactory managerHomeFactory, InstallableDistribution installableDistribution, DirectoryModel directoryModel, NetworkConfigurationModel networkConfigurationModel, DatabaseModel databaseModel, boolean applicationIsPreview) {
        InstallationDirectoryUtil.cleanupManagerHomeDirectory((Path)managerHomeFactory.getManagerHomeDirectory().toPath());
        InstallationDirectoryUtil.createInstallationProgressFile((Path)managerHomeFactory.getManagerHomeDirectory().toPath());
        InstallationDirectoryUtil.appendText((File)managerHomeFactory.getManagerHomeDirectory(), (String)("Started installation " + LocalDateTime.now()));
        ArrayList<AbstractInstallStep> mutableSteps = new ArrayList<AbstractInstallStep>();
        mutableSteps.add(new PrepareManagerHomeInstallStep(managerHomeFactory, networkConfigurationModel));
        mutableSteps.add(new PrepareDatabaseInstallStep(databaseModel));
        mutableSteps.add(new PackageManagerUpdatedPackageListInstallStep(installableDistribution));
        mutableSteps.add(new RequiredPackagesInstallStep(installableDistribution, applicationIsPreview));
        mutableSteps.add(new ConfigureTFTPInstallStep());
        mutableSteps.add(new ConfigureNFSInstallStep());
        mutableSteps.add(new ConfigureSyslogInstallStep());
        mutableSteps.add(new BootstrapLDAPInstallStep(directoryModel, installableDistribution, new ImportableProfileProvider(installableDistribution.getParent().getBaseURI())));
        mutableSteps.add(new FinalizeInstallationStep());
        this.steps = Collections.unmodifiableList(mutableSteps);
    }

    public InstallState getInstallState() {
        return this.installState;
    }

    public List<AbstractInstallStep> getSteps() {
        return this.steps;
    }

    @Override
    public Boolean call() throws Exception {
        this.installState = InstallState.RUNNING;
        InstallContext installContext = new InstallContext();
        try {
            this.steps.forEach(step -> step.execute(installContext));
        }
        catch (Exception e) {
            this.installState = InstallState.FAILED;
            throw e;
        }
        this.installState = InstallState.FINISHED;
        return true;
    }
}

