/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.inventory;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NetworkInterfaces {
    public static final String VIRTUAL_MAC_ADDRESS = "00-07-E9-37-2D-02";
    public static final String VMWARE_MAC_PREFIX = "00:50:56";
    public static final String PARALLELS_MAC_PREFIX = "00:1C:42";
    private final List<NetworkInterface> loopbackInterfaces = new ArrayList<NetworkInterface>();
    private final List<NetworkInterface> nonLoopbackInterfaces = new ArrayList<NetworkInterface>();

    public List<NetworkInterface> getLoopbackInterfaces() {
        return this.loopbackInterfaces;
    }

    public List<NetworkInterface> getNonLoopbackInterfaces() {
        return this.nonLoopbackInterfaces;
    }

    public Collection<NetworkInterface> getAllInterfaces() {
        ArrayList<NetworkInterface> all = new ArrayList<NetworkInterface>();
        all.addAll(this.loopbackInterfaces);
        all.addAll(this.nonLoopbackInterfaces);
        return all;
    }

    public String getHardwareAddressString(NetworkInterface nic) {
        byte[] hardwareAddress;
        try {
            hardwareAddress = nic.getHardwareAddress();
        }
        catch (SocketException e) {
            throw new RuntimeException("Failed to access the hardware address of the given network interface: " + nic.getDisplayName(), e);
        }
        if (hardwareAddress == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : hardwareAddress) {
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }
}

