/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.inventory;

import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import org.openthinclient.wizard.inventory.NetworkInterfaces;
import org.openthinclient.wizard.inventory.SystemInventory;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;

public class SystemInventoryFactory {
    private final AsyncListenableTaskExecutor executorService;

    public SystemInventoryFactory(AsyncListenableTaskExecutor executorService) {
        this.executorService = executorService;
    }

    public ListenableFuture<SystemInventory> determineSystemInventory() {
        return this.executorService.submitListenable(() -> new SystemInventory(this.collectNetworkInterfaces()));
    }

    private NetworkInterfaces collectNetworkInterfaces() throws SocketException {
        NetworkInterfaces nics = new NetworkInterfaces();
        ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
        interfaces.stream().filter(this::isLoopbackDevice).forEach(nics.getLoopbackInterfaces()::add);
        interfaces.stream().filter(this::isNonLoopbackDevice).forEach(nics.getNonLoopbackInterfaces()::add);
        return nics;
    }

    private boolean isNonLoopbackDevice(NetworkInterface networkInterface) {
        return !this.isLoopbackDevice(networkInterface);
    }

    private boolean isLoopbackDevice(NetworkInterface networkInterface) {
        return Collections.list(networkInterface.getInetAddresses()).stream().anyMatch(inetAddress -> inetAddress.isLoopbackAddress() || inetAddress.getHostAddress().equals("127.0.0.1"));
    }
}

