/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.model;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.openthinclient.wizard.check.CheckExecutionEngine;
import org.openthinclient.wizard.check.CheckExecutionResult;
import org.openthinclient.wizard.check.CheckFilesystemFreeSpace;
import org.openthinclient.wizard.check.CheckNetworkInferfaces;
import org.openthinclient.wizard.inventory.SystemInventory;
import org.openthinclient.wizard.model.CheckStatus;
import org.openthinclient.wizard.model.ManagerHomeModel;

public class CheckEnvironmentModel {
    private final CheckExecutionEngine checkExecutionEngine;
    private final List<CheckStatus> checkStates;
    private ManagerHomeModel managerHomeModel;

    public CheckEnvironmentModel(SystemInventory systemInventory, CheckExecutionEngine checkExecutionEngine, ManagerHomeModel managerHomeModel, int installationFreespaceMinimum) {
        this.checkExecutionEngine = checkExecutionEngine;
        this.managerHomeModel = managerHomeModel;
        Locale locale = Locale.ENGLISH;
        this.checkStates = new ArrayList<CheckStatus>();
        this.checkStates.add(new CheckStatus(new CheckNetworkInferfaces(locale, systemInventory)));
        this.checkStates.add(new CheckStatus(new CheckFilesystemFreeSpace(locale, this::getManagerHome, installationFreespaceMinimum)));
    }

    public List<CheckStatus> getCheckStates() {
        return this.checkStates;
    }

    protected Path getManagerHome() {
        return Paths.get(this.managerHomeModel.getManagerHomePath().getAbsolutePath(), new String[0]);
    }

    public void runChecks() {
        this.checkStates.forEach(check -> check.executeOn(this.checkExecutionEngine));
    }

    public boolean isRunning() {
        return this.checkStates.stream().anyMatch(CheckStatus::isRunning);
    }

    public boolean isAcceptable() {
        return this.checkStates.stream().allMatch(checkStatus -> !checkStatus.isRunning() && checkStatus.getResultType() != null && checkStatus.getResultType() != CheckExecutionResult.CheckResultType.FAILED);
    }

    public boolean allChecksRunned() {
        return this.checkStates.stream().allMatch(CheckStatus::isFinished);
    }
}

