/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.model;

import org.openthinclient.service.common.home.impl.ManagerHomeFactory;
import org.openthinclient.wizard.check.CheckExecutionEngine;
import org.openthinclient.wizard.inventory.SystemInventory;
import org.openthinclient.wizard.model.CheckEnvironmentModel;
import org.openthinclient.wizard.model.DatabaseModel;
import org.openthinclient.wizard.model.DirectoryModel;
import org.openthinclient.wizard.model.InstallModel;
import org.openthinclient.wizard.model.ManagerHomeModel;
import org.openthinclient.wizard.model.NetworkConfigurationModel;
import org.springframework.context.ApplicationContext;
import org.springframework.core.task.AsyncListenableTaskExecutor;

public class SystemSetupModel {
    private final NetworkConfigurationModel networkConfigurationModel;
    private final CheckEnvironmentModel checkEnvironmentModel;
    private final ManagerHomeModel managerHomeModel;
    private final InstallModel installModel;
    private final DirectoryModel directoryModel;
    private final DatabaseModel databaseModel;
    private final ManagerHomeFactory factory;
    private boolean installationResume;

    public SystemSetupModel(ManagerHomeFactory factory, SystemInventory systemInventory, CheckExecutionEngine checkExecutionEngine, ApplicationContext applicationContext, AsyncListenableTaskExecutor taskExecutor, int installationFreespaceMinimum) {
        this.factory = factory;
        this.networkConfigurationModel = new NetworkConfigurationModel();
        this.managerHomeModel = new ManagerHomeModel(factory, checkExecutionEngine);
        this.checkEnvironmentModel = new CheckEnvironmentModel(systemInventory, checkExecutionEngine, this.managerHomeModel, installationFreespaceMinimum);
        this.directoryModel = new DirectoryModel();
        this.databaseModel = new DatabaseModel();
        this.installModel = new InstallModel(taskExecutor, this.directoryModel, this.networkConfigurationModel, this.databaseModel);
    }

    public NetworkConfigurationModel getNetworkConfigurationModel() {
        return this.networkConfigurationModel;
    }

    public CheckEnvironmentModel getCheckEnvironmentModel() {
        return this.checkEnvironmentModel;
    }

    public ManagerHomeModel getManagerHomeModel() {
        return this.managerHomeModel;
    }

    public InstallModel getInstallModel() {
        return this.installModel;
    }

    public DirectoryModel getDirectoryModel() {
        return this.directoryModel;
    }

    public DatabaseModel getDatabaseModel() {
        return this.databaseModel;
    }

    public ManagerHomeFactory getFactory() {
        return this.factory;
    }

    public void setInstallationResume(boolean installationResume) {
        this.installationResume = installationResume;
    }

    public boolean isInstallationResume() {
        return this.installationResume;
    }
}

