/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.ui;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.ProgressBar;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.util.function.Consumer;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.ui.CheckingProgressPresenter;

public class CheckingProgressWindow
extends Window
implements CheckingProgressPresenter.View {
    private final Button okButton = new Button("OK");
    private final Button cancelButton = new Button("Cancel");
    private final ProgressBar progressBar = new ProgressBar();
    private final Label resultLabel = new Label();
    private Consumer<CheckingProgressPresenter.View> okHandler;
    private Consumer<CheckingProgressPresenter.View> cancelHandler;
    protected IMessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());

    public CheckingProgressWindow() {
        this.setContent((Component)this.createCheckingWindowContent());
        this.setModal(true);
        this.setResizable(false);
        this.setClosable(false);
        this.resultLabel.setVisible(false);
        this.okButton.addClickListener(this::onOkClicked);
        this.cancelButton.addClickListener(this::onCancelClicked);
    }

    private void onOkClicked(Button.ClickEvent clickEvent) {
        if (this.okHandler != null) {
            this.okHandler.accept(this);
        }
    }

    private void onCancelClicked(Button.ClickEvent clickEvent) {
        if (this.cancelHandler != null) {
            this.cancelHandler.accept(this);
        }
    }

    private VerticalLayout createCheckingWindowContent() {
        VerticalLayout components = new VerticalLayout();
        components.setSpacing(true);
        components.setMargin(true);
        Label label = new Label(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGURENETWORKSTEP_CHECK_NETWORK, new Object[0]));
        label.setStyleName("large");
        components.addComponent((Component)label);
        components.addComponent((Component)this.progressBar);
        components.addComponent((Component)this.resultLabel);
        HorizontalLayout footer = new HorizontalLayout();
        footer.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        footer.setStyleName("v-window-bottom-toolbar");
        footer.addComponent((Component)this.okButton);
        footer.addComponent((Component)this.cancelButton);
        components.addComponent((Component)footer);
        return components;
    }

    @Override
    public void accessUI(Consumer<CheckingProgressPresenter.View> consumer) {
        this.getUI().access(() -> consumer.accept(this));
    }

    @Override
    public void setInProgress() {
        this.progressBar.setIndeterminate(true);
        this.progressBar.setVisible(true);
        this.okButton.setEnabled(false);
        this.resultLabel.setVisible(false);
    }

    @Override
    public void setSuccess(String message) {
        this.okButton.setEnabled(true);
        this.progressBar.setValue(1.0f);
        this.progressBar.setVisible(false);
        this.resultLabel.setStyleName("success");
        this.resultLabel.setValue(message);
        this.resultLabel.setVisible(true);
    }

    @Override
    public void setError(String message) {
        this.okButton.setEnabled(false);
        this.progressBar.setValue(0.0f);
        this.progressBar.setVisible(false);
        this.resultLabel.setStyleName("failure");
        this.resultLabel.setValue(message);
        this.resultLabel.setVisible(true);
    }

    @Override
    public void setOnOkHandler(Consumer<CheckingProgressPresenter.View> handler) {
        this.okHandler = handler;
    }

    @Override
    public void setOnCancelHandler(Consumer<CheckingProgressPresenter.View> handler) {
        this.cancelHandler = handler;
    }
}

