/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.ui;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.annotations.Push;
import com.vaadin.annotations.Theme;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.Responsive;
import com.vaadin.server.Sizeable;
import com.vaadin.server.ThemeResource;
import com.vaadin.server.VaadinRequest;
import com.vaadin.spring.annotation.SpringUI;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Locale;
import org.openthinclient.api.distributions.InstallableDistribution;
import org.openthinclient.api.distributions.InstallableDistributions;
import org.openthinclient.i18n.LocaleUtil;
import org.openthinclient.manager.util.http.config.NetworkConfiguration;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.check.CheckExecutionEngine;
import org.openthinclient.wizard.model.SystemSetupModel;
import org.openthinclient.wizard.ui.ReinstallInformationPanel;
import org.openthinclient.wizard.ui.SystemInstallProgressPresenter;
import org.openthinclient.wizard.ui.SystemInstallProgressView;
import org.openthinclient.wizard.ui.steps.CheckEnvironmentStep;
import org.openthinclient.wizard.ui.steps.ConfigureDatabaseStep;
import org.openthinclient.wizard.ui.steps.ConfigureDirectoryStep;
import org.openthinclient.wizard.ui.steps.IntroStep;
import org.openthinclient.wizard.ui.steps.ReadyToInstallStep;
import org.openthinclient.wizard.ui.steps.net.ConfigureNetworkStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.vaadin.teemu.wizards.Wizard;
import org.vaadin.teemu.wizards.WizardStep;
import org.vaadin.teemu.wizards.event.WizardCancelledEvent;
import org.vaadin.teemu.wizards.event.WizardCompletedEvent;
import org.vaadin.teemu.wizards.event.WizardProgressListener;
import org.vaadin.teemu.wizards.event.WizardStepActivationEvent;
import org.vaadin.teemu.wizards.event.WizardStepSetChangedEvent;

@Theme(value="otc-wizard")
@SpringUI(path="/first-start")
@Push
public class FirstStartWizardUI
extends UI {
    private static final long serialVersionUID = 1127863296116812758L;
    Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private SystemSetupModel systemSetupModel;
    @Autowired
    private CheckExecutionEngine checkExecutionEngine;
    @Autowired
    private ApplicationEventPublisher publisher;
    private IMessageConveyor mc;
    @Value(value="${application.distribution}")
    private String distributionXml;
    @Value(value="${application.is-preview}")
    private boolean applicationisPreview;

    protected void init(VaadinRequest request) {
        this.setLocale(LocaleUtil.getLocaleForMessages(FirstStartWizardMessages.class, (Locale)UI.getCurrent().getLocale()));
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        Page.getCurrent().setTitle(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_PAGE_TITLE, new Object[0]));
        Responsive.makeResponsive((Component[])new Component[]{this});
        VerticalLayout root = new VerticalLayout();
        root.setMargin(false);
        root.addComponent((Component)this.createHeader());
        if (this.systemSetupModel.getInstallModel().isInstallInProgress()) {
            this.initInstallProgress(root);
        } else if (this.systemSetupModel.isInstallationResume()) {
            this.resumeInstallProgress(root);
        } else {
            this.initWizard(root);
        }
        this.setContent((Component)root);
    }

    private void resumeInstallProgress(final VerticalLayout root) {
        root.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        root.setHeight(null);
        ReinstallInformationPanel resumePanel = new ReinstallInformationPanel(root, this.systemSetupModel){

            @Override
            public void exitPanel() {
                FirstStartWizardUI.this.initWizard(root);
            }
        };
        root.addComponent((Component)resumePanel);
        root.setExpandRatio((Component)resumePanel, 1.0f);
    }

    private void initInstallProgress(VerticalLayout root) {
        root.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        root.setHeight(null);
        SystemInstallProgressView progressView = new SystemInstallProgressView();
        VerticalLayout viewWrapper = new VerticalLayout();
        viewWrapper.setMargin(true);
        viewWrapper.setSpacing(true);
        viewWrapper.setSizeFull();
        viewWrapper.addComponent((Component)progressView);
        root.addComponent((Component)viewWrapper);
        root.setExpandRatio((Component)viewWrapper, 1.0f);
        SystemInstallProgressPresenter presenter = new SystemInstallProgressPresenter(this.publisher, this.systemSetupModel.getInstallModel());
        presenter.present(this.getUI(), progressView);
    }

    private void initWizard(final VerticalLayout root) {
        root.setSizeFull();
        Wizard wizard = this.createWizard();
        final VerticalLayout wizardWrapper = new VerticalLayout();
        wizardWrapper.setMargin(false);
        wizardWrapper.setSpacing(true);
        wizardWrapper.setSizeFull();
        wizardWrapper.addComponent((Component)wizard);
        root.addComponent((Component)wizardWrapper);
        root.setExpandRatio((Component)wizardWrapper, 1.0f);
        wizard.addListener(new WizardProgressListener(){

            public void activeStepChanged(WizardStepActivationEvent event) {
            }

            public void stepSetChanged(WizardStepSetChangedEvent event) {
            }

            public void wizardCompleted(WizardCompletedEvent event) {
                InstallableDistribution installableDistribution = FirstStartWizardUI.this.systemSetupModel.getInstallModel().getInstallableDistributions().get(0);
                try {
                    InstallableDistributions officialDistribution;
                    URL officialURL = new URL(FirstStartWizardUI.this.distributionXml);
                    if (FirstStartWizardUI.this.systemSetupModel.getNetworkConfigurationModel().getDirectConnectionProperty().booleanValue()) {
                        officialDistribution = InstallableDistributions.load((URL)officialURL);
                    } else {
                        NetworkConfiguration.ProxyConfiguration proxyConf = FirstStartWizardUI.this.systemSetupModel.getNetworkConfigurationModel().getProxyConfiguration();
                        InetSocketAddress addr = new InetSocketAddress(proxyConf.getHost(), proxyConf.getPort());
                        officialDistribution = InstallableDistributions.load((URL)officialURL, (Proxy)new Proxy(Proxy.Type.HTTP, addr));
                    }
                    installableDistribution = officialDistribution.getPreferred();
                    FirstStartWizardUI.this.logger.info("Using official distribution: " + officialURL);
                }
                catch (Exception e) {
                    FirstStartWizardUI.this.logger.warn("Cannot load preferred official distribution: {} , falling back to {}", (Object)FirstStartWizardUI.this.distributionXml, (Object)installableDistribution);
                }
                FirstStartWizardUI.this.systemSetupModel.getInstallModel().installSystem(FirstStartWizardUI.this.systemSetupModel.getFactory(), installableDistribution, FirstStartWizardUI.this.applicationisPreview);
                root.removeComponent((Component)wizardWrapper);
                FirstStartWizardUI.this.initInstallProgress(root);
            }

            public void wizardCancelled(WizardCancelledEvent event) {
            }
        });
    }

    private Wizard createWizard() {
        Wizard wizard = new Wizard();
        wizard.setSizeFull();
        wizard.setUriFragmentEnabled(true);
        wizard.getCancelButton().setVisible(false);
        wizard.addStep((WizardStep)new IntroStep(this.systemSetupModel), "welcome");
        wizard.addStep((WizardStep)new ConfigureNetworkStep(wizard, this.checkExecutionEngine, this.systemSetupModel), "config-network");
        wizard.addStep((WizardStep)new CheckEnvironmentStep(wizard, this.systemSetupModel), "environment-check");
        wizard.addStep((WizardStep)new ConfigureDatabaseStep(this.systemSetupModel), "config-database");
        wizard.addStep((WizardStep)new ConfigureDirectoryStep(wizard, this.systemSetupModel), "directory");
        wizard.addStep((WizardStep)new ReadyToInstallStep(wizard), "install-ready");
        return wizard;
    }

    private CssLayout createHeader() {
        CssLayout header = new CssLayout();
        Image otcLogo = new Image();
        otcLogo.setSource((Resource)new ThemeResource("img/otc_toplogo32.png"));
        header.addComponent((Component)otcLogo);
        return header;
    }
}

