/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.ui.steps;

import com.vaadin.data.Binder;
import com.vaadin.data.Converter;
import com.vaadin.data.HasValue;
import com.vaadin.data.Result;
import com.vaadin.data.ValidationException;
import com.vaadin.data.Validator;
import com.vaadin.data.ValueContext;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Component;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.model.CheckStatus;
import org.openthinclient.wizard.model.ManagerHomeModel;
import org.openthinclient.wizard.model.SystemSetupModel;
import org.openthinclient.wizard.ui.steps.AbstractCheckExecutingStep;
import org.vaadin.teemu.wizards.Wizard;

public class ConfigureManagerHomeStep
extends AbstractCheckExecutingStep {
    private final SystemSetupModel systemSetupModel;
    private final VerticalLayout content;
    private final TextField homeDirectoryTextField;
    private AbstractCheckExecutingStep.CheckStatusLabel checkStatusLabel;
    private volatile boolean validatedProceed;
    private final Binder<ManagerHomeModel> binder;

    public ConfigureManagerHomeStep(Wizard wizard, final SystemSetupModel systemSetupModel) {
        super(wizard);
        this.systemSetupModel = systemSetupModel;
        this.binder = new Binder();
        this.binder.setBean((Object)systemSetupModel.getManagerHomeModel());
        this.homeDirectoryTextField = new TextField(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREMANAGERHOMESTEP_LABEL, new Object[0]));
        this.homeDirectoryTextField.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.homeDirectoryTextField.setStyleName("large");
        this.homeDirectoryTextField.setEnabled(systemSetupModel.getManagerHomeModel().isManagerHomeChangeable());
        this.binder.forField((HasValue)this.homeDirectoryTextField).withValidator((Validator)new StringLengthValidator(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREMANAGERHOMESTEP_VALIDATOR_DIRECTORYNAME, new Object[0]), Integer.valueOf(3), null)).withConverter((Converter)new Converter<String, File>(){

            public Result<File> convertToModel(String value, ValueContext context) {
                if (value == null || value.trim().length() == 0) {
                    Result.error((String)"manager home directory must not be empty");
                }
                systemSetupModel.getFactory().setManagerHomeDirectory(new File(value));
                return null;
            }

            public String convertToPresentation(File value, ValueContext context) {
                return value != null ? value.getAbsolutePath() : "/opt/openthinclient-home";
            }
        }).bind(ManagerHomeModel::getManagerHomePath, ManagerHomeModel::setManagerHomePath);
        this.content = new VerticalLayout(new Component[]{this.createLabelH1(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREMANAGERHOMESTEP_HEADLINE, new Object[0])), this.createLabelHuge(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREMANAGERHOMESTEP_TEXT, new Object[0])), this.homeDirectoryTextField});
        this.content.setSpacing(true);
        this.content.setMargin(true);
        this.setContent((Component)this.content);
    }

    public String getCaption() {
        return this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGUREMANAGERHOMESTEP_TITLE, new Object[0]);
    }

    public boolean onAdvance() {
        if (this.validatedProceed) {
            this.validatedProceed = true;
            return true;
        }
        if (this.systemSetupModel.getManagerHomeModel().isManagerHomeChangeable()) {
            try {
                this.binder.writeBean((Object)this.systemSetupModel.getManagerHomeModel());
            }
            catch (ValidationException e) {
                return false;
            }
        }
        if (this.systemSetupModel.getManagerHomeModel().isManagerHomeSpecified() && !this.systemSetupModel.getManagerHomeModel().isManagerHomeValidated()) {
            this.runChecks();
            return false;
        }
        return this.systemSetupModel.getManagerHomeModel().isManagerHomeValid();
    }

    public boolean onBack() {
        return true;
    }

    @Override
    protected List<AbstractCheckExecutingStep.CheckStatusLabel> getStatusLabels() {
        if (this.checkStatusLabel != null) {
            return Collections.singletonList(this.checkStatusLabel);
        }
        return Collections.emptyList();
    }

    @Override
    protected void onRunChecks() {
        CheckStatus checkStatus = this.systemSetupModel.getManagerHomeModel().runCheck();
        if (this.checkStatusLabel != null) {
            this.content.removeComponent((Component)this.checkStatusLabel);
        }
        this.checkStatusLabel = new AbstractCheckExecutingStep.CheckStatusLabel(checkStatus);
        this.content.addComponent((Component)this.checkStatusLabel);
    }

    @Override
    protected void onChecksFinished() {
        if (this.systemSetupModel.getManagerHomeModel().isManagerHomeValid()) {
            this.validatedProceed = true;
            this.wizard.next();
        }
    }

    @Override
    protected boolean isChecksFinished() {
        return this.systemSetupModel.getManagerHomeModel().isManagerHomeValidated();
    }
}

