/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.wizard.ui.steps.net;

import com.vaadin.data.HasValue;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import org.openthinclient.wizard.FirstStartWizardMessages;
import org.openthinclient.wizard.check.CheckExecutionEngine;
import org.openthinclient.wizard.check.CheckInternetConnection;
import org.openthinclient.wizard.model.SystemSetupModel;
import org.openthinclient.wizard.ui.CheckingProgressPresenter;
import org.openthinclient.wizard.ui.CheckingProgressWindow;
import org.openthinclient.wizard.ui.steps.AbstractStep;
import org.openthinclient.wizard.ui.steps.net.ProxyConfigurationForm;
import org.vaadin.teemu.wizards.Wizard;
import org.vaadin.teemu.wizards.WizardStep;

public class ConfigureNetworkStep
extends AbstractStep
implements WizardStep {
    private final CheckBox directConnectionCheckBox;
    private final CheckBox proxyConnectionCheckBox;
    private final ProxyConfigurationForm proxyConfigurationForm;
    private final Wizard wizard;
    private final CheckExecutionEngine checkExecutionEngine;
    private final SystemSetupModel systemSetupModel;
    private boolean checkSucessfullyRun;

    public ConfigureNetworkStep(Wizard wizard, CheckExecutionEngine checkExecutionEngine, SystemSetupModel systemSetupModel) {
        this.wizard = wizard;
        this.checkExecutionEngine = checkExecutionEngine;
        this.systemSetupModel = systemSetupModel;
        VerticalLayout layout = new VerticalLayout();
        layout.setSpacing(true);
        layout.setMargin(true);
        Label title = this.createLabelH1(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGURENETWORKSTEP_HEADLINE, new Object[0]));
        layout.addComponent((Component)title);
        layout.setComponentAlignment((Component)title, Alignment.MIDDLE_LEFT);
        this.directConnectionCheckBox = new CheckBox(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGURENETWORKSTEP_DIRECT_CONNECTION, new Object[0]), systemSetupModel.getNetworkConfigurationModel().getDirectConnectionProperty().booleanValue());
        this.directConnectionCheckBox.setStyleName("large");
        layout.addComponent((Component)this.directConnectionCheckBox);
        this.proxyConnectionCheckBox = new CheckBox(this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGURENETWORKSTEP_PROXY_CONNECTION, new Object[0]), systemSetupModel.getNetworkConfigurationModel().getProxyConnectionProperty().booleanValue());
        this.proxyConnectionCheckBox.setStyleName("large");
        this.proxyConfigurationForm = this.createProxyConfigurationForm();
        this.proxyConnectionCheckBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            this.proxyConfigurationForm.setEnabled(this.proxyConnectionCheckBox.getValue());
            this.directConnectionCheckBox.setValue(Boolean.valueOf(this.proxyConnectionCheckBox.getValue() == false));
            if (this.proxyConnectionCheckBox.getValue().booleanValue()) {
                systemSetupModel.getNetworkConfigurationModel().enableProxyConnectionProperty();
            }
        });
        this.directConnectionCheckBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            this.proxyConfigurationForm.setEnabled(this.directConnectionCheckBox.getValue() == false);
            this.proxyConnectionCheckBox.setValue(Boolean.valueOf(this.directConnectionCheckBox.getValue() == false));
            if (this.directConnectionCheckBox.getValue().booleanValue()) {
                systemSetupModel.getNetworkConfigurationModel().enableDirectConnectionProperty();
            }
        });
        this.proxyConfigurationForm.setEnabled(this.proxyConnectionCheckBox.getValue());
        HorizontalLayout proxyConfig = new HorizontalLayout(new Component[]{this.proxyConnectionCheckBox, this.proxyConfigurationForm});
        proxyConfig.setSpacing(true);
        layout.addComponent((Component)proxyConfig);
        this.setContent((Component)layout);
    }

    public String getCaption() {
        return this.mc.getMessage((Enum)FirstStartWizardMessages.UI_FIRSTSTART_INSTALLSTEPS_CONFIGURENETWORKSTEP_TITLE, new Object[0]);
    }

    protected ProxyConfigurationForm createProxyConfigurationForm() {
        return new ProxyConfigurationForm(this.systemSetupModel.getNetworkConfigurationModel());
    }

    public boolean onAdvance() {
        if (this.systemSetupModel.getNetworkConfigurationModel().getNoConnectionProperty().booleanValue()) {
            return true;
        }
        if (this.checkSucessfullyRun) {
            return true;
        }
        if (this.proxyConnectionCheckBox.getValue().booleanValue()) {
            this.proxyConfigurationForm.commit();
        }
        CheckingProgressWindow checkingProgressWindow = new CheckingProgressWindow();
        this.wizard.getUI().addWindow((Window)checkingProgressWindow);
        CheckInternetConnection check = new CheckInternetConnection(UI.getCurrent().getLocale());
        if (this.systemSetupModel.getNetworkConfigurationModel().getProxyConnectionProperty().booleanValue()) {
            check.setProxyConfiguration(this.systemSetupModel.getNetworkConfigurationModel().getProxyConfiguration());
        }
        CheckingProgressPresenter presenter = new CheckingProgressPresenter(this.checkExecutionEngine, checkingProgressWindow, result -> {
            if (result == CheckingProgressPresenter.Result.SUCCESS_OK) {
                this.checkSucessfullyRun = true;
                this.wizard.getUI().access(() -> ((Wizard)this.wizard).next());
            }
        });
        presenter.execute(check);
        return false;
    }

    public boolean onBack() {
        return true;
    }
}

