/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.i18n;

import com.vaadin.ui.UI;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.NoSuchMessageException;

public class I18N {
    private final ApplicationContext applicationContext;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean revertToDefaultBundle = true;

    @Autowired
    public I18N(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public boolean isRevertToDefaultBundle() {
        return this.revertToDefaultBundle;
    }

    public void setRevertToDefaultBundle(boolean revertToDefaultBundle) {
        this.revertToDefaultBundle = revertToDefaultBundle;
    }

    public String get(String code, Object ... arguments) {
        try {
            return this.getMessage(code, null, arguments);
        }
        catch (NoSuchMessageException ex) {
            this.logger.warn("Tried to retrieve message with code [{}] that does not exist", (Object)code);
            return "!" + code;
        }
    }

    public String get(String code, Locale locale, Object ... arguments) {
        if (locale == null) {
            throw new IllegalArgumentException("Locale must not be null");
        }
        try {
            return this.getMessage(code, locale, arguments);
        }
        catch (NoSuchMessageException ex) {
            this.logger.warn("Tried to retrieve message with code [{}] that does not exist", (Object)code);
            return "!" + code;
        }
    }

    @Deprecated
    public String getWithLocale(String code, Locale locale, Object ... arguments) {
        return this.get(code, locale, arguments);
    }

    public String getWithDefault(String code, String defaultMessage, Object ... arguments) {
        try {
            return this.getMessage(code, null, arguments);
        }
        catch (NoSuchMessageException ex) {
            return defaultMessage;
        }
    }

    public String getWithDefault(String code, Locale locale, String defaultMessage, Object ... arguments) {
        if (locale == null) {
            throw new IllegalArgumentException("Locale must not be null");
        }
        try {
            return this.getMessage(code, locale, arguments);
        }
        catch (NoSuchMessageException ex) {
            return defaultMessage;
        }
    }

    private String getMessage(String code, Locale locale, Object ... arguments) {
        Locale actualLocale = locale == null ? this.getLocale() : locale;
        try {
            return this.applicationContext.getMessage(code, arguments, actualLocale);
        }
        catch (NoSuchMessageException ex) {
            if (this.isRevertToDefaultBundle()) {
                return this.applicationContext.getMessage(code, arguments, null);
            }
            throw ex;
        }
    }

    public Locale getLocale() {
        Locale locale;
        UI currentUI = UI.getCurrent();
        Locale locale2 = locale = currentUI == null ? null : currentUI.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }
}

