/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr;

import java.util.List;
import javax.batch.api.chunk.listener.SkipProcessListener;
import javax.batch.api.chunk.listener.SkipReadListener;
import javax.batch.api.chunk.listener.SkipWriteListener;
import javax.batch.operations.BatchRuntimeException;
import org.springframework.batch.core.SkipListener;

public class SkipListenerAdapter<T, S>
implements SkipListener<T, S> {
    private final SkipReadListener skipReadDelegate;
    private final SkipProcessListener skipProcessDelegate;
    private final SkipWriteListener skipWriteDelegate;

    public SkipListenerAdapter(SkipReadListener skipReadDelegate, SkipProcessListener skipProcessDelegate, SkipWriteListener skipWriteDelegate) {
        this.skipReadDelegate = skipReadDelegate;
        this.skipProcessDelegate = skipProcessDelegate;
        this.skipWriteDelegate = skipWriteDelegate;
    }

    @Override
    public void onSkipInRead(Throwable t) {
        if (this.skipReadDelegate != null && t instanceof Exception) {
            try {
                this.skipReadDelegate.onSkipReadItem((Exception)t);
            }
            catch (Exception e) {
                throw new BatchRuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public void onSkipInWrite(S item, Throwable t) {
        if (this.skipWriteDelegate != null && t instanceof Exception) {
            try {
                this.skipWriteDelegate.onSkipWriteItem((List)item, (Exception)t);
            }
            catch (Exception e) {
                throw new BatchRuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public void onSkipInProcess(T item, Throwable t) {
        if (this.skipProcessDelegate != null && t instanceof Exception) {
            try {
                this.skipProcessDelegate.onSkipProcessItem(item, (Exception)t);
            }
            catch (Exception e) {
                throw new BatchRuntimeException((Throwable)e);
            }
        }
    }
}

