/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.openthinclient.manager.util.http.config.NetworkConfiguration;
import org.openthinclient.manager.util.http.impl.AbstractHttpAccessorBase;
import org.openthinclient.pkgmgr.PackageManagerConfiguration;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.sysreport.SystemReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemReportPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemReportPublisher.class);
    private static final char[] ID_CHARS = "abcdefghkmnorstuvwxyz23456789".toCharArray();
    private static final int ID_LENGTH = 6;
    private final ManagerHome managerHome;
    private final Uploader uploader;

    public SystemReportPublisher(ManagerHome managerHome) {
        this.managerHome = managerHome;
        this.uploader = new Uploader(((PackageManagerConfiguration)managerHome.getConfiguration(PackageManagerConfiguration.class)).getProxyConfiguration());
    }

    public static String createSupportId() {
        SecureRandom random = new SecureRandom();
        char[] chars = new char[6];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = ID_CHARS[random.nextInt(chars.length)];
        }
        return new String(chars);
    }

    private String createReportFileName(String supportId) {
        return "sysreport-" + this.managerHome.getMetadata().getServerID() + "__" + supportId + ".json";
    }

    public SystemReportUploadResult upload(SystemReport report) {
        Path tempFile;
        String supportId = SystemReportPublisher.createSupportId();
        try {
            tempFile = this.serializeToTempFile(report);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write system report", e);
        }
        String serverId = this.managerHome.getMetadata().getServerID();
        this.uploader.upload(tempFile, serverId, supportId);
        return new SystemReportUploadResult(serverId, supportId);
    }

    private Path serializeToTempFile(SystemReport report) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectWriter writer = mapper.writer();
        Path tempFile = Files.createTempFile("system-report-", ".json", new FileAttribute[0]);
        LOGGER.info("Storing system report to temporary file {}", (Object)tempFile);
        try (OutputStream out = Files.newOutputStream(tempFile, new OpenOption[0]);){
            writer.writeValue(out, (Object)report);
        }
        return tempFile;
    }

    public static class Uploader
    extends AbstractHttpAccessorBase {
        private static final URI BASE_URI = URI.create("https://uht94fkwy5.execute-api.eu-central-1.amazonaws.com/production/system-report");

        public Uploader(NetworkConfiguration.ProxyConfiguration proxyConfig) {
            super(proxyConfig, "openthinclient.org manager");
        }

        public void upload(Path reportFile, String serverId, String supportId) {
            HttpResponse response;
            HttpPost put = new HttpPost(BASE_URI);
            put.setHeader("x-otc-server-id", serverId);
            put.setHeader("x-otc-support-id", supportId);
            put.setEntity((HttpEntity)new FileEntity(reportFile.toFile(), ContentType.APPLICATION_JSON));
            try {
                response = this.httpClient.execute((HttpUriRequest)put);
            }
            catch (IOException e) {
                throw new RuntimeException("Report upload failed", e);
            }
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode > 299) {
                LOGGER.error("System report upload failed.", (Object)response);
                throw new RuntimeException("Report upload failed. HTTP Status: " + statusCode + ". " + response.getStatusLine().getReasonPhrase());
            }
        }
    }

    public static final class SystemReportUploadResult {
        private final String serverId;
        private final String supportId;

        public SystemReportUploadResult(String serverId, String supportId) {
            this.serverId = serverId;
            this.supportId = supportId;
        }

        public String getServerId() {
            return this.serverId;
        }

        public String getSupportId() {
            return this.supportId;
        }

        public String toString() {
            return "SystemReportUploadResult{serverId='" + this.serverId + '\'' + ", supportId='" + this.supportId + '\'' + '}';
        }
    }
}

