/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.openthinclient.api.ws.WebSocketHandler;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.service.ClientService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketSession;

@Component
@EnableScheduling
public class ClientStatus {
    private static final long STATUS_UPDATE_INTERVAL = 3000L;
    private static final long HEARTBEAT_TOLERANCE = 10000L;
    Pattern MAC_LINE = Pattern.compile("^MAC:((?:[0-9a-f]{2}:){5}[0-9a-f]{2})$", 8);
    @Autowired
    WebSocketHandler webSocket;
    @Autowired
    ClientService clientService;
    Map<String, Long> clients;

    @PostConstruct
    public void init() {
        this.clients = new HashMap<String, Long>();
        this.webSocket.register("heartbeat", this::onHeartbeat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onHeartbeat(WebSocketSession session, String message) {
        String remote_ip = session.getRemoteAddress().getAddress().getHostAddress();
        Matcher matcher = this.MAC_LINE.matcher(message);
        Map<String, Long> map = this.clients;
        synchronized (map) {
            while (matcher.find()) {
                String mac = matcher.group(1);
                if (!this.clients.containsKey(mac)) {
                    for (Client client : this.clientService.findByHwAddress(mac)) {
                        client.setIpHostNumber(remote_ip);
                        new Thread(() -> this.clientService.save((DirectoryObject)client)).start();
                    }
                }
                this.clients.put(mac, System.currentTimeMillis());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(fixedRate=3000L)
    public void checkClientsStatus() {
        long cutOff = System.currentTimeMillis() - 10000L;
        Map<String, Long> map = this.clients;
        synchronized (map) {
            this.clients.values().removeIf(timestamp -> timestamp < cutOff);
        }
    }

    public boolean isOnline(String mac) {
        return this.clients.containsKey(mac);
    }

    public Set<String> getOnlineMACs() {
        return Collections.unmodifiableSet(this.clients.keySet());
    }
}

