/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web;

import com.vaadin.data.HasValue;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.data.provider.Query;
import com.vaadin.event.selection.SelectionEvent;
import com.vaadin.event.selection.SelectionListener;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.shared.ui.grid.HeightMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Grid;
import com.vaadin.ui.Label;
import com.vaadin.ui.StyleGenerator;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.components.grid.SingleSelectionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.openthinclient.common.model.ClientMetaData;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.web.sidebar.OTCSideBarUtils;
import org.openthinclient.web.thinclient.AbstractDirectoryObjectView;
import org.openthinclient.web.thinclient.ApplicationGroupView;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.UserGroupView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.spring.sidebar.SideBarItemDescriptor;
import org.vaadin.spring.sidebar.SideBarSectionDescriptor;
import org.vaadin.spring.sidebar.SideBarUtils;
import org.vaadin.spring.sidebar.components.AbstractSideBar;
import org.vaadin.spring.sidebar.components.ValoSideBar;

public class OTCSideBar
extends ValoSideBar {
    private static final Logger LOGGER = LoggerFactory.getLogger(OTCSideBar.class);
    public static final String SIDE_BAR_STYLE = "sideBar";
    public static final String SIDE_BAR_SECTION_ITEM_STYLE = "sideBarSectionItem";
    public static final String SIDE_BAR_SECTION_STYLE = "sideBarSection";
    public static final String SELECTED_STYLE = "selected";
    private OTCSideBarUtils sideBarUtils;
    private Map<SideBarItemDescriptor, FilterGrid> itemsMap = new HashMap<SideBarItemDescriptor, FilterGrid>();
    private Map<String, FilterGrid> filterGridMap = new HashMap<String, FilterGrid>();
    private Map<String, SideBarItemDescriptor> descriptorMap = new HashMap<String, SideBarItemDescriptor>();
    private final String sectionId;

    public OTCSideBar(String sectionId, OTCSideBarUtils sideBarUtils) {
        super((SideBarUtils)sideBarUtils);
        this.sideBarUtils = sideBarUtils;
        this.sectionId = sectionId;
    }

    protected AbstractSideBar.SectionComponentFactory<CssLayout> createDefaultSectionComponentFactory() {
        return new DefaultSectionComponentFactory();
    }

    protected AbstractSideBar.ItemComponentFactory createDefaultItemComponentFactory() {
        return new DefaultItemComponentFactory();
    }

    public void updateFilterGrid(View view, String directoryObjectName) {
        if (!(view instanceof AbstractDirectoryObjectView)) {
            return;
        }
        String viewName = ((AbstractDirectoryObjectView)view).getParentViewName();
        this.itemsMap.values().forEach(gridComponent -> gridComponent.setVisible(false));
        FilterGrid filterGrid = this.filterGridMap.get(viewName);
        if (filterGrid != null) {
            if (filterGrid.getSize() == 0) {
                filterGrid.setItems(this.getAllItems(this.descriptorMap.get(viewName)));
            }
            filterGrid.markSelectedItem(directoryObjectName);
            filterGrid.setVisible(true);
        }
    }

    public void selectItem(String viewName, DirectoryObject directoryObject, Set<? extends DirectoryObject> directoryObjectSet) {
        FilterGrid filterGrid = this.filterGridMap.get(viewName);
        if (filterGrid != null) {
            filterGrid.setItems(directoryObjectSet);
            filterGrid.setVisible(true);
            if (directoryObject == null) {
                filterGrid.markSelectedItem("");
            } else {
                filterGrid.markSelectedItem(directoryObject.getName());
            }
        }
    }

    private void showContent(String viewName, SelectionEvent<DirectoryObject> selectionEvent) {
        Optional selectedItem = selectionEvent.getFirstSelectedItem();
        if (selectionEvent.isUserOriginated()) {
            Navigator navigator = UI.getCurrent().getNavigator();
            if (selectedItem.isPresent()) {
                String navigationState = viewName + "/edit/" + ((DirectoryObject)selectedItem.get()).getName();
                LOGGER.info("Navigate to " + navigationState);
                navigator.navigateTo(navigationState);
            }
        }
    }

    private Set<DirectoryObject> getAllItems(SideBarItemDescriptor item) {
        Optional<Map.Entry> nameType = this.sideBarUtils.getNameTypeMap().entrySet().stream().filter(entry -> item.getItemId().contains(((String)entry.getKey()).toLowerCase())).findFirst();
        if (nameType.isPresent()) {
            Class sideBarItemClass = (Class)nameType.get().getValue();
            LOGGER.debug("Fetch menu-items for {}", (Object)sideBarItemClass);
            Object bean = this.sideBarUtils.getApplicationContext().getBean(sideBarItemClass);
            if (bean instanceof AbstractDirectoryObjectView) {
                return ((AbstractDirectoryObjectView)((Object)bean)).getAllItems();
            }
        }
        return new HashSet<DirectoryObject>();
    }

    private void showGridItems(SideBarItemDescriptor descriptor) {
        FilterGrid grid = this.itemsMap.get(descriptor);
        grid.setItems(this.getAllItems(descriptor));
        grid.setVisible(true);
        this.itemsMap.entrySet().stream().filter(e -> !((SideBarItemDescriptor)e.getKey()).equals(descriptor)).forEach(e -> ((FilterGrid)((Object)((Object)e.getValue()))).setVisible(false));
    }

    public void attach() {
        super.attach();
        if (this.getUI().getNavigator() == null) {
            throw new IllegalStateException("Please configure the Navigator before you attach the SideBar to the UI");
        }
        CssLayout compositionRoot = this.createCompositionRoot();
        this.setCompositionRoot((Component)compositionRoot);
        for (SideBarSectionDescriptor section : this.sideBarUtils.getSideBarSections(this.getUI().getClass())) {
            if (!section.getId().equals(this.sectionId)) continue;
            this.createSection(compositionRoot, section, this.sideBarUtils.getSideBarItems(section));
        }
    }

    private void createSection(CssLayout compositionRoot, SideBarSectionDescriptor section, Collection<SideBarItemDescriptor> items) {
        if (this.getItemFilter() == null) {
            this.getSectionComponentFactory().createSection((ComponentContainer)compositionRoot, section, items);
        } else {
            ArrayList<SideBarItemDescriptor> passedItems = new ArrayList<SideBarItemDescriptor>();
            for (SideBarItemDescriptor candidate : items) {
                if (!this.getItemFilter().passesFilter(candidate)) continue;
                passedItems.add(candidate);
            }
            if (!passedItems.isEmpty()) {
                this.getSectionComponentFactory().createSection((ComponentContainer)compositionRoot, section, passedItems);
            }
        }
    }

    class ViewItemButton
    extends ItemButton
    implements ViewChangeListener {
        private final String viewName;
        private static final String STYLE_SELECTED = "selected";
        private static final String STYLE_UNSELECTED = "unselected";

        ViewItemButton(SideBarItemDescriptor.ViewItemDescriptor descriptor) {
            super((SideBarItemDescriptor)descriptor);
            this.viewName = descriptor.getViewName();
        }

        public void attach() {
            super.attach();
            if (this.getUI().getNavigator() == null) {
                throw new IllegalStateException("Please configure the Navigator before you attach the SideBar to the UI");
            }
            this.getUI().getNavigator().addViewChangeListener((ViewChangeListener)this);
        }

        public void detach() {
            this.getUI().getNavigator().removeViewChangeListener((ViewChangeListener)this);
            super.detach();
        }

        public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
            return true;
        }

        public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
            View newView = event.getNewView();
            if (this.viewName.equals(event.getViewName()) || newView instanceof AbstractDirectoryObjectView && this.viewName.equals(((AbstractDirectoryObjectView)newView).getParentViewName())) {
                this.removeStyleName(STYLE_UNSELECTED);
                this.addStyleName("selected");
                boolean isGroupView = newView instanceof ApplicationGroupView || newView instanceof UserGroupView;
                String[] params = Optional.ofNullable(event.getParameters()).orElse("").split("/", 2);
                String currentObjectName = params.length == 2 && "edit".equals(params[0]) ? params[1] : "";
                Optional<SideBarItemDescriptor> descriptor = OTCSideBar.this.itemsMap.keySet().stream().filter(sbid -> sbid.getItemId().endsWith(this.viewName.replaceAll("_", "").toLowerCase())).findFirst();
                if (descriptor.isPresent()) {
                    Grid grid = ((FilterGrid)((Object)OTCSideBar.this.itemsMap.get(descriptor.get()))).itemGrid;
                    Optional<DirectoryObject> directoryObjectOptional = grid.getDataProvider().fetch(new Query()).filter(d -> currentObjectName.equals(d.getName())).findFirst();
                    if (directoryObjectOptional.isPresent() && !isGroupView) {
                        grid.select((Object)directoryObjectOptional.get());
                    } else {
                        grid.deselectAll();
                    }
                }
            } else {
                this.removeStyleName("selected");
                this.addStyleName(STYLE_UNSELECTED);
                FilterGrid filterGrid = (FilterGrid)((Object)OTCSideBar.this.filterGridMap.get(this.viewName));
                if (filterGrid != null) {
                    filterGrid.setVisible(false);
                }
            }
        }
    }

    class ItemButton
    extends Button {
        CssLayout compositionRoot;

        ItemButton(SideBarItemDescriptor descriptor) {
            this.setPrimaryStyleName("valo-menu-item");
            this.addStyleName(descriptor.getItemId().substring("sidebaritem_".length()));
            if (OTCSideBar.this.itemsMap.containsKey(descriptor)) {
                this.addStyleName("has-items");
            }
            this.setCaption(descriptor.getCaption());
            this.setIcon(descriptor.getIcon());
            this.setId(descriptor.getItemId());
            this.setDisableOnClick(true);
            this.addClickListener((Button.ClickListener & Serializable)event -> {
                try {
                    descriptor.itemInvoked(this.getUI());
                    if (this.compositionRoot != null && OTCSideBar.this.itemsMap.containsKey(descriptor)) {
                        OTCSideBar.this.showGridItems(descriptor);
                    }
                }
                finally {
                    this.setEnabled(true);
                }
            });
        }

        public void setCompositionRoot(CssLayout compositionRoot) {
            this.compositionRoot = compositionRoot;
        }
    }

    public class DefaultItemComponentFactory
    implements AbstractSideBar.ItemComponentFactory {
        public Component createItemComponent(SideBarItemDescriptor descriptor) {
            if (descriptor instanceof SideBarItemDescriptor.ViewItemDescriptor) {
                return new ViewItemButton((SideBarItemDescriptor.ViewItemDescriptor)descriptor);
            }
            return new ItemButton(descriptor);
        }
    }

    class FilterGrid
    extends CssLayout {
        private final Label filterStatus;
        private final TextField filter;
        private List<? extends DirectoryObject> groupedItems;
        private Grid<DirectoryObject> itemGrid;

        public FilterGrid(SideBarItemDescriptor item, AbstractDirectoryObjectView bean) {
            this.setVisible(false);
            this.addStyleNames(new String[]{"filterGrid"});
            CssLayout filterRow = new CssLayout();
            filterRow.addStyleNames(new String[]{"filterRow"});
            this.filter = new TextField();
            this.filter.setPlaceholder("Filter");
            this.filter.addValueChangeListener(this::onFilterTextChange);
            filterRow.addComponent((Component)this.filter);
            this.filterStatus = new Label();
            this.filterStatus.addStyleName("profileItemFilterStatus");
            filterRow.addComponent((Component)this.filterStatus);
            this.addComponent((Component)filterRow);
            this.itemGrid = new Grid();
            this.itemGrid.addStyleNames(new String[]{"profileSelectionGrid"});
            this.itemGrid.addStyleName(item.getItemId().substring("sidebaritem_".length()));
            this.itemGrid.setSelectionMode(Grid.SelectionMode.SINGLE);
            SingleSelectionModel singleSelect = (SingleSelectionModel)this.itemGrid.getSelectionModel();
            singleSelect.setDeselectAllowed(false);
            this.itemGrid.addColumn(DirectoryObject::getName);
            this.itemGrid.addSelectionListener((SelectionListener & Serializable)selectionEvent -> OTCSideBar.this.showContent(bean.getViewName(), (SelectionEvent<DirectoryObject>)selectionEvent));
            this.itemGrid.removeHeaderRow(0);
            this.itemGrid.setSizeFull();
            this.itemGrid.setHeightMode(HeightMode.UNDEFINED);
            this.itemGrid.setStyleGenerator((StyleGenerator & Serializable)profile -> profile.getClass().getSimpleName());
            this.addComponent((Component)this.itemGrid);
        }

        private void onFilterTextChange(HasValue.ValueChangeEvent<String> event) {
            ListDataProvider dataProvider = (ListDataProvider)this.itemGrid.getDataProvider();
            long groupHeader = dataProvider.getItems().stream().filter(i -> i.getClass().equals(ProfilePropertiesBuilder.MenuGroupProfile.class)).count();
            dataProvider.setFilter((SerializablePredicate & Serializable)directoryObject -> {
                if (directoryObject instanceof ProfilePropertiesBuilder.MenuGroupProfile) {
                    return true;
                }
                if (directoryObject instanceof ClientMetaData) {
                    ClientMetaData client = (ClientMetaData)directoryObject;
                    String macAddress = client.getMacAddress();
                    String[] data = new String[]{client.getName(), macAddress, macAddress.replace(":", ""), client.getIpHostNumber()};
                    return Stream.of(data).filter(Objects::nonNull).map(String::toLowerCase).anyMatch(where -> where.contains((CharSequence)event.getValue()));
                }
                return this.caseInsensitiveContains(directoryObject.getName(), (String)event.getValue());
            });
            long filteredGroupHeader = dataProvider.fetch(new Query()).filter(i -> i.getClass().equals(ProfilePropertiesBuilder.MenuGroupProfile.class)).count();
            this.filterStatus.setCaption((long)dataProvider.size(new Query()) - filteredGroupHeader + "/" + ((long)dataProvider.getItems().size() - groupHeader));
        }

        private Boolean caseInsensitiveContains(String where, String what) {
            return where.toLowerCase().contains(what.toLowerCase());
        }

        public int getSize() {
            DataProvider dataProvider = this.itemGrid.getDataProvider();
            return dataProvider.size(new Query());
        }

        public void setItems(Set<? extends DirectoryObject> items) {
            this.groupedItems = ProfilePropertiesBuilder.createGroupedItems(items);
            long groupHeader = this.groupedItems.stream().filter(i -> i.getClass().equals(ProfilePropertiesBuilder.MenuGroupProfile.class)).count();
            ListDataProvider dataProvider = DataProvider.ofCollection(this.groupedItems);
            this.itemGrid.setDataProvider((DataProvider)dataProvider);
            long visibleItems = (long)dataProvider.getItems().size() - groupHeader;
            this.filterStatus.setCaption(visibleItems + "/" + items.size());
            if (visibleItems > 0L) {
                this.itemGrid.setHeightByRows((double)visibleItems);
            }
            this.filter.setValue("");
        }

        public void markSelectedItem(String directoryObjectName) {
            if (directoryObjectName == null || directoryObjectName.isEmpty()) {
                this.itemGrid.deselectAll();
            } else {
                int pos = 0;
                for (DirectoryObject directoryObject : this.groupedItems) {
                    if (directoryObject.getName().equals(directoryObjectName)) {
                        this.itemGrid.getSelectionModel().select((Object)directoryObject);
                        this.itemGrid.scrollTo(pos);
                        break;
                    }
                    ++pos;
                }
            }
        }

        public DirectoryObject getSelectedItem() {
            return (DirectoryObject)this.itemGrid.getSelectedItems().iterator().next();
        }
    }

    public class DefaultSectionComponentFactory
    implements AbstractSideBar.SectionComponentFactory<CssLayout> {
        private AbstractSideBar.ItemComponentFactory itemComponentFactory;

        public void setItemComponentFactory(AbstractSideBar.ItemComponentFactory itemComponentFactory) {
            this.itemComponentFactory = itemComponentFactory;
        }

        public void createSection(CssLayout compositionRoot, SideBarSectionDescriptor descriptor, Collection<SideBarItemDescriptor> itemDescriptors) {
            for (SideBarItemDescriptor item : itemDescriptors) {
                Optional<Map.Entry> nameType;
                ItemButton itemComponent = (ItemButton)this.itemComponentFactory.createItemComponent(item);
                itemComponent.setCompositionRoot(compositionRoot);
                compositionRoot.addComponent((Component)itemComponent);
                if (item.getItemId().equals("sidebaritem_realmsettingsview") || !(nameType = OTCSideBar.this.sideBarUtils.getNameTypeMap().entrySet().stream().filter(entry -> item.getItemId().contains(((String)entry.getKey()).toLowerCase())).findFirst()).isPresent()) continue;
                Class sideBarItemClass = (Class)nameType.get().getValue();
                Object bean = OTCSideBar.this.sideBarUtils.getApplicationContext().getBean(sideBarItemClass);
                if (!(bean instanceof AbstractDirectoryObjectView)) continue;
                FilterGrid filterGrid = new FilterGrid(item, (AbstractDirectoryObjectView)((Object)bean));
                compositionRoot.addComponent((Component)filterGrid);
                OTCSideBar.this.itemsMap.put(item, filterGrid);
                if (!(item instanceof SideBarItemDescriptor.ViewItemDescriptor)) continue;
                String viewName = ((SideBarItemDescriptor.ViewItemDescriptor)item).getViewName();
                OTCSideBar.this.filterGridMap.put(viewName, filterGrid);
                OTCSideBar.this.descriptorMap.put(viewName, item);
            }
        }
    }
}

