/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.component;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.shared.ui.window.WindowMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import java.io.Serializable;
import org.openthinclient.web.i18n.ConsoleWebMessages;

public class Popup {
    private Window popup;
    private CssLayout contentLayout = new CssLayout();
    private CssLayout buttonsLayout = new CssLayout();
    private String width;
    private WindowMode windowMode = WindowMode.NORMAL;
    static MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());

    public Popup(ConsoleWebMessages title_key, String ... styleNames) {
        this(mc.getMessage((Enum)title_key, new Object[0]), styleNames);
    }

    public Popup(String title, String ... styleNames) {
        this.contentLayout.addStyleName("content");
        this.contentLayout.addStyleNames(styleNames);
        this.buttonsLayout.addStyleName("buttons");
        CssLayout wrapper = new CssLayout(new Component[]{this.contentLayout, this.buttonsLayout});
        wrapper.addStyleName("wrapper");
        this.popup = new Window(title, (Component)wrapper);
        this.popup.addStyleName("otc-popup");
        this.popup.setModal(true);
        this.popup.addCloseShortcut(27, new int[0]);
        this.popup.addCloseListener((Window.CloseListener & Serializable)ev -> UI.getCurrent().removeWindow(this.popup));
        this.popup.addWindowModeChangeListener((Window.WindowModeChangeListener & Serializable)ev -> {
            if (ev.getWindowMode() == WindowMode.MAXIMIZED) {
                this.popup.addStyleName("maximized");
            } else {
                this.popup.removeStyleName("maximized");
            }
        });
    }

    public void open() {
        if (this.buttonsLayout.getComponentCount() == 0) {
            this.buttonsLayout.addComponent((Component)new Button(mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_CLOSE, new Object[0]), (Button.ClickListener & Serializable)ev -> this.popup.close()));
        }
        Button outsidePopupButton = new Button("", (Button.ClickListener & Serializable)ev -> this.popup.close());
        outsidePopupButton.setStyleName("outside-popup");
        this.buttonsLayout.addComponent((Component)outsidePopupButton);
        this.popup.setWindowMode(this.windowMode);
        this.popup.setSizeUndefined();
        this.popup.setWidth(this.width);
        this.popup.center();
        UI.getCurrent().addWindow(this.popup);
    }

    public void close() {
        this.popup.close();
    }

    public void addContent(Component ... content) {
        this.contentLayout.addComponents(content);
    }

    public void addButton(Button ... buttons) {
        this.buttonsLayout.addComponents((Component[])buttons);
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public void setMaximized(boolean maximized) {
        this.windowMode = maximized ? WindowMode.MAXIMIZED : WindowMode.NORMAL;
    }
}

