/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.pkgmngr.ui.presenter;

import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.server.SerializablePredicate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.web.pkgmngr.ui.presenter.PackageListMasterDetailsPresenter;
import org.openthinclient.web.pkgmngr.ui.view.ResolvedPackageItem;
import org.springframework.context.ApplicationContext;

public class AvailablePackageListMasterDetailsPresenter
extends PackageListMasterDetailsPresenter {
    public AvailablePackageListMasterDetailsPresenter(PackageListMasterDetailsPresenter.View view, Consumer<Collection<Package>> detailsPresenter, PackageManager packageManager, ClientService clientService, ApplicationContext applicationContext) {
        super(view, detailsPresenter, packageManager, clientService, applicationContext);
        view.getAllPackagesFilterCheckbox().setVisible(true);
        view.getPreviewPackagesFilterCheckbox().setVisible(true);
    }

    @Override
    protected void applyFilters() {
        Boolean showAllVersions;
        super.applyFilters();
        Boolean showPreviewVersions = this.view.getPreviewPackagesFilterCheckbox().getValue();
        if (!showPreviewVersions.booleanValue()) {
            this.dataProvider.addFilter((SerializablePredicate)new NoPreviewFilter((ListDataProvider<ResolvedPackageItem>)this.dataProvider));
        }
        if (!(showAllVersions = this.view.getAllPackagesFilterCheckbox().getValue()).booleanValue()) {
            this.dataProvider.addFilter((SerializablePredicate)new NotInstalledFilter(this.packageManager));
            this.dataProvider.addFilter((SerializablePredicate)new PackageListMasterDetailsPresenter.LatestVersionOnlyFilter((ListDataProvider<ResolvedPackageItem>)this.dataProvider));
        }
    }

    public static class NoPreviewFilter
    implements SerializablePredicate<ResolvedPackageItem> {
        private final List<Package> previewVersionPackageList;

        public NoPreviewFilter(ListDataProvider<ResolvedPackageItem> dataProvider) {
            this.previewVersionPackageList = dataProvider.getItems().stream().map(item -> item.getPackage()).filter(pkg -> pkg.getVersion().isPreview()).collect(Collectors.toList());
        }

        public boolean test(ResolvedPackageItem item) {
            return !this.previewVersionPackageList.contains(item.getPackage());
        }
    }

    public static class NotInstalledFilter
    implements SerializablePredicate<ResolvedPackageItem> {
        private Map<String, Package> installedPackages;

        public NotInstalledFilter(PackageManager packageManager) {
            this.installedPackages = packageManager.getInstalledPackages().stream().collect(Collectors.toMap(Package::getName, pkg -> pkg));
        }

        public boolean test(ResolvedPackageItem item) {
            return !this.installedPackages.containsKey(item.getName()) || item.getPackage().getVersion().isPreview() && !this.installedPackages.get(item.getName()).getVersion().isPreview();
        }
    }
}

