/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.pkgmngr.ui.view;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.Query;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Grid;
import com.vaadin.ui.StyleGenerator;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.UI;
import java.util.Collections;
import java.util.List;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.pkgmngr.ui.design.PackageDetailsDesign;
import org.openthinclient.web.pkgmngr.ui.presenter.PackageDetailsPresenter;
import org.openthinclient.web.pkgmngr.ui.view.AbstractPackageItem;
import org.openthinclient.web.pkgmngr.ui.view.MissingPackageItem;

public class PackageDetailsView
extends PackageDetailsDesign
implements PackageDetailsPresenter.View {
    private static final long serialVersionUID = -2726203031530856857L;
    private final TabSheet.Tab tabDependencies;
    private final TabSheet.Tab tabProvides;
    private final TabSheet.Tab tabConflicts;
    private final TabSheet.Tab tabRelations;

    public PackageDetailsView() {
        MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.dependencies.setDataProvider((DataProvider)DataProvider.ofCollection(Collections.emptyList()));
        this.dependencies.setSelectionMode(Grid.SelectionMode.NONE);
        this.dependencies.addColumn(AbstractPackageItem::getName).setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_NAME, new Object[0]));
        this.dependencies.addColumn(AbstractPackageItem::getDisplayVersion).setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_VERSION, new Object[0]));
        this.dependencies.setHeight("39px");
        this.dependencies.setStyleGenerator((StyleGenerator)new StyleGenerator<AbstractPackageItem>(){

            public String apply(AbstractPackageItem item) {
                if (item != null && item instanceof MissingPackageItem) {
                    return "highlight-red";
                }
                return null;
            }
        });
        this.conflicts.setDataProvider((DataProvider)DataProvider.ofCollection(Collections.emptyList()));
        this.conflicts.setSelectionMode(Grid.SelectionMode.NONE);
        this.conflicts.addColumn(AbstractPackageItem::getName).setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_NAME, new Object[0]));
        this.conflicts.addColumn(AbstractPackageItem::getDisplayVersion).setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_VERSION, new Object[0]));
        this.conflicts.setHeight("39px");
        this.provides.setDataProvider((DataProvider)DataProvider.ofCollection(Collections.emptyList()));
        this.provides.setSelectionMode(Grid.SelectionMode.NONE);
        this.provides.addColumn(AbstractPackageItem::getName).setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_NAME, new Object[0]));
        this.provides.addColumn(AbstractPackageItem::getDisplayVersion).setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_VERSION, new Object[0]));
        this.provides.setHeight("39px");
        this.changeLog.setContentMode(ContentMode.PREFORMATTED);
        this.acceptLicenseCheckbox.setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_DETAILS_LICENSE_CHECKBOX_CAPTION, new Object[0]));
        this.mainTabSheet.getTab((Component)this.tabComponentCommon).setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_DETAILS_COMMON_CAPTION, new Object[0]));
        this.tabRelations = this.mainTabSheet.getTab((Component)this.tabComponentRelations);
        this.tabRelations.setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_DETAILS_RELATIONS_CAPTION, new Object[0]));
        this.mainTabSheet.getTab((Component)this.tabComponentChangelog).setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_DETAILS_CHANGELOG_CAPTION, new Object[0]));
        this.mainTabSheet.getTab((Component)this.tabComponentLicense).setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_DETAILS_LICENSE_CAPTION, new Object[0]));
        this.tabDependencies = this.relationsTabSheet.getTab((Component)this.dependencies);
        this.tabDependencies.setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_DETAILS_RELATIONS_DEPENDENCIES_CAPTION, new Object[0]));
        this.tabProvides = this.relationsTabSheet.getTab((Component)this.provides);
        this.tabProvides.setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_DETAILS_RELATIONS_PROVIDES_CAPTION, new Object[0]));
        this.tabConflicts = this.relationsTabSheet.getTab((Component)this.conflicts);
        this.tabConflicts.setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_DETAILS_RELATIONS_CONFLICTS_CAPTION, new Object[0]));
        this.updateRelationsTabs();
    }

    @Override
    public ComponentContainer getActionBar() {
        return this.inlineActionBar;
    }

    @Override
    public void setName(String name) {
        this.name.setValue(name);
    }

    @Override
    public void setVersion(String version) {
        this.version.setValue(version);
    }

    @Override
    public void setDescription(String description) {
        this.description.setValue(description);
    }

    @Override
    public void setLicense(String license) {
        this.license.setValue(license);
    }

    @Override
    public void hide() {
        this.setVisible(false);
    }

    @Override
    public void show() {
        this.setVisible(true);
    }

    @Override
    public void setShortDescription(String shortDescription) {
        this.shortDescription.setValue(shortDescription);
    }

    @Override
    public void setSourceUrl(String url) {
        this.sourceUrl.setValue(url);
    }

    @Override
    public void setChangeLog(String changeLog) {
        this.changeLog.setValue(changeLog);
    }

    @Override
    public void hideConflictsTable() {
        this.conflicts.setVisible(false);
    }

    @Override
    public void hideProvidesTable() {
        this.provides.setVisible(false);
    }

    @Override
    public CheckBox getLicenseCheckbox() {
        return this.acceptLicenseCheckbox;
    }

    @Override
    public void addDependencies(List<AbstractPackageItem> depends) {
        if (depends != null) {
            this.dependencies.setDataProvider((DataProvider)DataProvider.ofCollection(depends));
            this.dependencies.setHeight(39 + depends.size() * 38 + "px");
        }
        this.updateRelationsTabs();
    }

    private void updateRelationsTabs() {
        if (!(this.hasDependencies() || this.hasConflicts() || this.hasProvides())) {
            this.tabRelations.setVisible(false);
            return;
        }
        this.tabRelations.setVisible(true);
        this.tabProvides.setVisible(this.hasProvides());
        this.tabConflicts.setVisible(this.hasConflicts());
        this.tabDependencies.setVisible(this.hasDependencies());
    }

    private boolean hasProvides() {
        return this.provides.getDataProvider().size(new Query()) != 0;
    }

    private boolean hasConflicts() {
        return this.conflicts.getDataProvider().size(new Query()) != 0;
    }

    private boolean hasDependencies() {
        return this.dependencies.getDataProvider().size(new Query()) != 0;
    }

    @Override
    public void addConflicts(List<AbstractPackageItem> packageConflicts) {
        if (this.conflicts != null) {
            this.conflicts.setDataProvider((DataProvider)DataProvider.ofCollection(packageConflicts));
            this.conflicts.setHeight(39 + packageConflicts.size() * 38 + "px");
        }
        this.updateRelationsTabs();
    }

    @Override
    public void addProvides(List<AbstractPackageItem> packageProvides) {
        if (this.provides != null) {
            this.provides.setDataProvider((DataProvider)DataProvider.ofCollection(packageProvides));
            this.provides.setHeight(39 + packageProvides.size() * 38 + "px");
        }
        this.updateRelationsTabs();
    }
}

