/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.pkgmngr.ui.view;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.event.selection.SelectionListener;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Grid;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.components.grid.HeaderRow;
import com.vaadin.ui.components.grid.ItemClickListener;
import com.vaadin.ui.renderers.AbstractRenderer;
import com.vaadin.ui.renderers.ComponentRenderer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.pkgmngr.ui.design.PackageListMasterDetailsDesign;
import org.openthinclient.web.pkgmngr.ui.presenter.PackageListMasterDetailsPresenter;
import org.openthinclient.web.pkgmngr.ui.view.AbstractPackageItem;
import org.openthinclient.web.pkgmngr.ui.view.ResolvedPackageItem;

public class PackageListMasterDetailsView
extends PackageListMasterDetailsDesign
implements PackageListMasterDetailsPresenter.View {
    private static final long serialVersionUID = 6572660094735789367L;
    private DataProvider<ResolvedPackageItem, ?> packageListDataProvider;
    private Consumer<Package> showPackageDetailsConsumer;
    private boolean detailsVisible;
    private float previousSplitPosition;
    private Sizeable.Unit previousSplitPositionUnit;
    private TextField filterInput;
    private CheckBox allPackagesFilterCheckbox;
    private CheckBox previewPackagesFilterCheckbox;

    public PackageListMasterDetailsView() {
        MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.setDataProvider((DataProvider<ResolvedPackageItem, ?>)DataProvider.ofCollection(Collections.emptyList()));
        this.packageList.setSelectionMode(Grid.SelectionMode.MULTI);
        this.packageList.addColumn(AbstractPackageItem::getName).setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_NAME, new Object[0])).setId("name");
        Grid.Column versionColumn = this.packageList.addColumn(AbstractPackageItem::getDisplayVersion).setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_VERSION, new Object[0])).setId("displayVersion");
        Grid.Column detailsColumn = this.packageList.addColumn(arg_0 -> this.lambda$new$c4617110$1((IMessageConveyor)mc, arg_0), (AbstractRenderer)new ComponentRenderer()).setCaption("");
        this.packageList.addItemClickListener((ItemClickListener & Serializable)event -> {
            if (event.getColumn() == null) {
                return;
            }
            if (this.packageList.getSelectedItems().contains(event.getItem())) {
                this.packageList.deselect(event.getItem());
            } else {
                this.packageList.select(event.getItem());
            }
        });
        this.filterInput = new TextField();
        this.filterInput.setStyleName("filter-input");
        this.filterInput.setPlaceholder(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_SEARCHFIELD_INPUTPROMPT, new Object[0]));
        this.allPackagesFilterCheckbox = new CheckBox(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_SHOW_ALL_VERSIONS, new Object[0]));
        this.previewPackagesFilterCheckbox = new CheckBox(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_SHOW_PREVIEW_VERSIONS, new Object[0]));
        CssLayout toggles = new CssLayout();
        toggles.setStyleName("toggles");
        toggles.addComponents(new Component[]{this.allPackagesFilterCheckbox, this.previewPackagesFilterCheckbox});
        HeaderRow filterRow = this.packageList.addHeaderRowAt(0);
        filterRow.setStyleName("filter-row");
        filterRow.getCell("name").setComponent((Component)this.filterInput);
        filterRow.join(Stream.of(versionColumn, detailsColumn).map(arg_0 -> ((HeaderRow)filterRow).getCell(arg_0)).collect(Collectors.toSet())).setComponent((Component)toggles);
        this.detailsVisible = true;
        this.setDetailsVisible(false);
        this.previousSplitPosition = 70.0f;
        this.previousSplitPositionUnit = Sizeable.Unit.PERCENTAGE;
        this.sourceUpdateButton.setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_SOURCE_UPDATE_NOW_BUTTON, new Object[0]));
    }

    @Override
    public void setDataProvider(DataProvider<ResolvedPackageItem, ?> dataProvider) {
        this.packageListDataProvider = dataProvider;
        this.packageList.setDataProvider(this.packageListDataProvider);
    }

    @Override
    public void onPackageSelected(Consumer<Collection<Package>> consumer) {
        this.packageList.addSelectionListener((SelectionListener & Serializable)event -> {
            Set value = event.getAllSelectedItems();
            consumer.accept(value.stream().map(rpi -> rpi.getPackage()).collect(Collectors.toCollection(ArrayList::new)));
        });
    }

    @Override
    public void onShowPackageDetails(Consumer<Package> consumer) {
        this.showPackageDetailsConsumer = consumer;
    }

    public ComponentContainer getDetailsContainer() {
        return this.detailsContainer;
    }

    @Override
    public TextField getFilterInput() {
        return this.filterInput;
    }

    @Override
    public CheckBox getAllPackagesFilterCheckbox() {
        return this.allPackagesFilterCheckbox;
    }

    @Override
    public CheckBox getPreviewPackagesFilterCheckbox() {
        return this.previewPackagesFilterCheckbox;
    }

    @Override
    public void sort(PackageListMasterDetailsPresenter.View.SortableProperty property, SortDirection direction) {
        this.packageList.sort(property.getBeanPropertyName(), direction);
    }

    @Override
    public void hideSourceUpdatePanel() {
        this.sourceUpdatePanel.setVisible(false);
    }

    @Override
    public void setSourceUpdateLabelValue(String text) {
        this.sourceUpdateLabel.setValue(text);
    }

    @Override
    public Button getSourceUpdateButton() {
        return this.sourceUpdateButton;
    }

    @Override
    public void clearSelection() {
        this.packageList.getSelectionModel().deselectAll();
    }

    @Override
    public void setDetailsVisible(boolean visible) {
        if (this.detailsVisible == visible) {
            return;
        }
        if (this.detailsVisible) {
            this.previousSplitPosition = this.splitPanel.getSplitPosition();
            this.previousSplitPositionUnit = this.splitPanel.getSplitPositionUnit();
            this.splitPanel.setSplitPosition(99.0f, Sizeable.Unit.PERCENTAGE);
        } else {
            this.splitPanel.setSplitPosition(this.previousSplitPosition, this.previousSplitPositionUnit);
        }
        this.detailsVisible = visible;
    }

    private /* synthetic */ Component lambda$new$c4617110$1(IMessageConveyor mc, ResolvedPackageItem item) {
        Button moreButton = new Button();
        moreButton.addStyleName("details-button");
        moreButton.setCaption(mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_LIST_DETAILS_CAPTION, new Object[0]));
        moreButton.setIcon((Resource)VaadinIcons.INFO_CIRCLE_O);
        moreButton.addStyleNames(new String[]{"link"});
        moreButton.addClickListener((Button.ClickListener & Serializable)e -> {
            if (this.showPackageDetailsConsumer != null && item instanceof ResolvedPackageItem) {
                this.showPackageDetailsConsumer.accept(item.getPackage());
            }
        });
        return moreButton;
    }
}

