/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.support;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.navigator.View;
import com.vaadin.server.FileDownloader;
import com.vaadin.server.Resource;
import com.vaadin.server.StreamResource;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.Upload;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.PostConstruct;
import org.openthinclient.api.ldif.export.LdifExporterService;
import org.openthinclient.api.ldif.export.LdifImporterService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.web.event.DashboardEvent;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.ui.SettingsUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.SideBarItem;

@SpringView(name="ldif-import-export", ui={SettingsUI.class})
@SideBarItem(sectionId="server-management", captionCode="UI_SUPPORT_LDIF_IMPORT_EXPORT_HEADER", order=71)
public class LdifImportExportView
extends Panel
implements View {
    private static final Logger LOGGER = LoggerFactory.getLogger(LdifImportExportView.class);
    @Autowired
    protected ManagerHome managerHome;
    @Autowired
    private RealmService realmService;
    private EventBus.SessionEventBus eventBus;
    final MessageConveyor mc;
    final CssLayout root;
    private File file;
    private Label importSuccessLabel;
    private Label importErrorLabel;
    private Label exportErrorLabel;
    private Label exportSuccessLabel;

    public LdifImportExportView(EventBus.SessionEventBus eventBus) {
        this.eventBus = eventBus;
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.setSizeFull();
        this.root = new CssLayout();
        this.root.setStyleName("importexport");
        this.setContent((Component)this.root);
    }

    public String getCaption() {
        return this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LDIF_IMPORT_EXPORT_HEADER, new Object[0]);
    }

    @PostConstruct
    private void init() {
        this.buildContent();
    }

    private void buildContent() {
        this.exportSuccessLabel = this.buildFeedbackLabel(ConsoleWebMessages.UI_SUPPORT_LDIF_EXPORT_SUCCESS, "success");
        this.exportErrorLabel = this.buildFeedbackLabel(ConsoleWebMessages.UI_SUPPORT_LDIF_EXPORT_FAILED, "failure");
        this.root.addComponent((Component)new CssLayout(new Component[]{new CssLayout(new Component[]{this.buildExportButton(), this.exportSuccessLabel, this.exportErrorLabel}), new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LDIF_EXPORT_DESCRIPTION, new Object[0]), ContentMode.HTML)}));
        this.importSuccessLabel = this.buildFeedbackLabel(ConsoleWebMessages.UI_SUPPORT_LDIF_IMPORT_SUCCESS, "success");
        this.importErrorLabel = this.buildFeedbackLabel(ConsoleWebMessages.UI_SUPPORT_LDIF_IMPORT_FAILED, "failure");
        this.root.addComponent((Component)new CssLayout(new Component[]{new CssLayout(new Component[]{this.buildUploadButton(), this.importSuccessLabel, this.importErrorLabel}), new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LDIF_IMPORT_DESCRIPTION, new Object[0]), ContentMode.HTML)}));
    }

    private Label buildFeedbackLabel(ConsoleWebMessages msg, String ... styleNames) {
        Label label = new Label(this.mc.getMessage((Enum)msg, new Object[0]), ContentMode.HTML);
        label.setVisible(false);
        label.addStyleNames(styleNames);
        return label;
    }

    private Button buildExportButton() {
        Button exportButton = new Button("LDIF Export");
        exportButton.addStyleName("ldif-export");
        FileDownloader fileDownloader = new FileDownloader((Resource)this.createDownloadResource());
        fileDownloader.extend((AbstractComponent)exportButton);
        return exportButton;
    }

    private Upload buildUploadButton() {
        Upload upload = new Upload(null, (Upload.Receiver & Serializable)(filename, mimeType) -> {
            try {
                this.file = File.createTempFile(filename, "ldif", this.managerHome.getLocation());
                return new FileOutputStream(this.file);
            }
            catch (IOException e) {
                LOGGER.error("Could not open file", (Throwable)e);
                return null;
            }
        });
        upload.addStyleName("ldif-import");
        upload.setButtonCaption("LDIF Import");
        upload.setAcceptMimeTypes("text/ldif");
        upload.addSucceededListener((Upload.SucceededListener & Serializable)ev -> this.importLdifFile(this.file));
        upload.addFailedListener((Upload.FailedListener & Serializable)ev -> this.uploadFailed(ev.getReason()));
        upload.setImmediateMode(true);
        upload.addStartedListener((Upload.StartedListener & Serializable)e -> {
            this.importSuccessLabel.setVisible(false);
            this.importErrorLabel.setVisible(false);
            this.getUI().access(() -> this.getUI().push());
        });
        return upload;
    }

    private StreamResource createDownloadResource() {
        return new StreamResource((StreamResource.StreamSource & Serializable)() -> {
            this.exportErrorLabel.setVisible(false);
            this.exportSuccessLabel.setVisible(false);
            this.getUI().access(() -> this.getUI().push());
            LdifExporterService ldifExporterService = new LdifExporterService(this.realmService.getDefaultRealm().getConnectionDescriptor());
            HashSet exportResult = new HashSet();
            byte[] bytes = ldifExporterService.performAction(Collections.singleton(""), exportResult::add);
            if (exportResult.contains(LdifExporterService.State.ERROR) || exportResult.contains(LdifExporterService.State.EXCEPTION)) {
                this.exportErrorLabel.setVisible(true);
                this.getUI().access(() -> this.getUI().push());
                return null;
            }
            this.exportSuccessLabel.setVisible(true);
            this.getUI().access(() -> this.getUI().push());
            return new ByteArrayInputStream(bytes);
        }, "openthinclient-export.ldif");
    }

    private void importLdifFile(File file) {
        LdifImporterService lis = new LdifImporterService(this.realmService.getDefaultRealm().getConnectionDescriptor());
        HashSet importResult = new HashSet();
        try {
            lis.importTempFile(file, importResult::add);
            if (importResult.contains(LdifImporterService.State.ERROR) || importResult.contains(LdifImporterService.State.EXCEPTION)) {
                this.importErrorLabel.setVisible(true);
            } else {
                this.importSuccessLabel.setVisible(true);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to import file " + file.getName(), (Throwable)e);
            this.importErrorLabel.setVisible(true);
        }
        this.getUI().access(() -> this.getUI().push());
        this.eventBus.publish((Object)this, (Object)new DashboardEvent.LDAPImportEvent());
        file.delete();
    }

    private void uploadFailed(Exception exception) {
        LOGGER.error("Failed to import LDIF-file.", (Throwable)exception);
        this.importErrorLabel.setVisible(true);
        this.getUI().access(() -> this.getUI().push());
    }
}

