/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.support;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.HasValue;
import com.vaadin.navigator.View;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.ItemCaptionGenerator;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.PrefixFileFilter;
import org.openthinclient.common.model.ClientMetaData;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.sidebar.annotation.SideBarItem;

@SpringView(name="logfiles")
@SideBarItem(sectionId="server-management", captionCode="UI_SUPPORT_LOGS_HEADER", order=80)
public class LogFilesView
extends Panel
implements View {
    private static final Logger LOG = LoggerFactory.getLogger(LogFilesView.class);
    @Autowired
    private ManagerHome managerHome;
    @Autowired
    private ClientService clientService;
    private final MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
    private final CssLayout root;
    private Path logDir;

    public LogFilesView() {
        this.setSizeFull();
        this.root = new CssLayout();
        this.root.setStyleName("logfilesview");
        this.setContent((Component)this.root);
    }

    public String getCaption() {
        return this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LOGS_HEADER, new Object[0]);
    }

    @PostConstruct
    private void init() {
        this.logDir = this.managerHome.getLocation().toPath().resolve("logs");
        this.root.addComponents(new Component[]{new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LOGS_DESCRIPTION, new Object[]{this.logDir.toString()}), ContentMode.HTML), this.buildLogBox(ConsoleWebMessages.UI_SUPPORT_LOGS_SERVER_HEADER, ConsoleWebMessages.UI_SUPPORT_LOGS_SERVER_DESCRIPTION, this.buildFileListing("openthinclient-manager.")), this.buildLogBox(ConsoleWebMessages.UI_SUPPORT_LOGS_AUDIT_HEADER, ConsoleWebMessages.UI_SUPPORT_LOGS_AUDIT_DESCRIPTION, this.buildFileListing("audit.")), this.buildLogBox(ConsoleWebMessages.UI_SUPPORT_LOGS_CLIENT_HEADER, ConsoleWebMessages.UI_SUPPORT_LOGS_CLIENT_DESCRIPTION, this.buildClientSelectorAndFileListing())});
    }

    private Component buildLogBox(ConsoleWebMessages header, ConsoleWebMessages description, Component component) {
        CssLayout content = new CssLayout();
        Label title = new Label(this.mc.getMessage((Enum)header, new Object[0]));
        title.addStyleName("title");
        content.addComponents(new Component[]{title, new Label(this.mc.getMessage((Enum)description, new Object[0])), component});
        return content;
    }

    private Component buildClientSelectorAndFileListing() {
        CssLayout content = new CssLayout();
        content.addStyleName("client-logs");
        Label unselectedLabel = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LOGS_NO_CLIENT_SELECTED, new Object[0]));
        ComboBox clientCombo = new ComboBox();
        clientCombo.setItemCaptionGenerator((ItemCaptionGenerator & Serializable)client -> String.format("%s (%s / %s)", client.getName(), client.getMacAddress(), client.getIpHostNumber()));
        clientCombo.setItems(this.clientService.findAllClientMetaData().stream().sorted(Comparator.comparing(DirectoryObject::getName, String::compareToIgnoreCase)));
        clientCombo.setPlaceholder(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LOGS_CLIENT_SELECT_PLACEHOLDER, new Object[0]));
        clientCombo.setSizeUndefined();
        clientCombo.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> {
            Label component;
            ClientMetaData client = (ClientMetaData)event.getValue();
            if (client == null) {
                component = unselectedLabel;
            } else {
                String glob = String.format("%s.", client.getMacAddress());
                component = this.buildFileListing("syslog", glob);
            }
            content.removeComponent(content.getComponent(content.getComponentCount() - 1));
            content.addComponent((Component)component);
        });
        content.addComponents(new Component[]{clientCombo, unselectedLabel});
        return content;
    }

    private Component buildFileListing(String ... location) {
        String[] pathParts = Arrays.copyOf(location, location.length - 1);
        String glob = location[location.length - 1];
        CssLayout content = new CssLayout();
        Path dir = this.managerHome.getLocation().toPath().resolve("logs");
        StringBuilder urlBuilder = new StringBuilder("/openthinclient/logs/");
        for (String pathPart : pathParts) {
            dir = dir.resolve(pathPart);
            urlBuilder.append(pathPart).append("/");
        }
        File[] files = dir.toFile().listFiles((FilenameFilter)new PrefixFileFilter(glob));
        if (files == null) {
            LOG.error("Error while listing log files.");
            Label result = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LOGS_ACCESS_ERROR, new Object[0]));
            result.addStyleName("error");
            content.addComponent((Component)result);
            return content;
        }
        if (files.length == 0) {
            content.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LOGS_NO_FILES_FOUND, new Object[0])));
            return content;
        }
        Arrays.sort(files, LastModifiedFileComparator.LASTMODIFIED_REVERSE);
        for (File file : files) {
            String fileName = file.getName();
            String url = new StringBuilder(urlBuilder).append(fileName).toString();
            Label link = new Label(String.format("<a href=\"%s\" download>%s</a>", url, fileName), ContentMode.HTML);
            content.addComponent((Component)link);
            String size = FileUtils.byteCountToDisplaySize((long)file.length());
            content.addComponent((Component)new Label(size));
        }
        content.addStyleName("file-listing");
        return content;
    }
}

