/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.support;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Responsive;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import javax.annotation.PostConstruct;
import org.openthinclient.manager.util.http.DownloadManager;
import org.openthinclient.manager.util.http.config.NetworkConfiguration;
import org.openthinclient.pkgmgr.PackageManagerConfiguration;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.web.Audit;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.support.ProxyConfigurationForm;
import org.openthinclient.web.ui.SettingsUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.sidebar.annotation.SideBarItem;

@SpringView(name="proxy-config", ui={SettingsUI.class})
@SideBarItem(sectionId="server-management", captionCode="UI_SUPPORT_PROXY_CONFIGURATION_HEADER", order=40)
public class ProxyConfigurationView
extends Panel
implements View {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyConfigurationView.class);
    @Autowired
    private ManagerHome managerHome;
    @Autowired
    private DownloadManager downloadManager;
    final MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
    final VerticalLayout root;

    public ProxyConfigurationView() {
        this.setSizeFull();
        this.root = new VerticalLayout();
        this.root.setSizeFull();
        this.root.setMargin(true);
        this.setContent((Component)this.root);
        Responsive.makeResponsive((Component[])new Component[]{this.root});
    }

    public String getCaption() {
        return this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_PROXY_CONFIGURATION_HEADER, new Object[0]);
    }

    @PostConstruct
    private void init() {
        this.buildContent();
    }

    private void buildContent() {
        VerticalLayout content = new VerticalLayout();
        final Label successLabel = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_PROXY_CONFIGURATION_SUCCESS, new Object[0]), ContentMode.HTML);
        successLabel.setVisible(false);
        final Label errorLabel = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_PROXY_CONFIGURATION_ERROR, new Object[0]), ContentMode.HTML);
        errorLabel.setVisible(false);
        errorLabel.setStyleName("unexpected_error");
        Label labelDescription = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_PROXY_CONFIGURATION_DESCRIPTION, new Object[0]), ContentMode.HTML);
        PackageManagerConfiguration configuration = (PackageManagerConfiguration)this.managerHome.getConfiguration(PackageManagerConfiguration.class);
        NetworkConfiguration.ProxyConfiguration proxyConfiguration = configuration.getProxyConfiguration();
        if (proxyConfiguration == null) {
            proxyConfiguration = new NetworkConfiguration.ProxyConfiguration();
            configuration.setProxyConfiguration(proxyConfiguration);
        }
        final NetworkConfiguration.ProxyConfiguration finalProxyConfiguration = proxyConfiguration;
        ProxyConfigurationForm proxyConfigurationForm = new ProxyConfigurationForm(proxyConfiguration){

            @Override
            public void saveValues() {
                successLabel.setVisible(false);
                errorLabel.setVisible(false);
                this.commit();
                ProxyConfigurationView.this.cleanupValues();
                try {
                    ProxyConfigurationView.this.managerHome.save(PackageManagerConfiguration.class);
                    Audit.logSave("Proxy settings", new String[0]);
                    ProxyConfigurationView.this.downloadManager.setProxy(finalProxyConfiguration);
                    successLabel.setVisible(true);
                    super.resetValues();
                }
                catch (Exception e) {
                    LOGGER.error("Failed to save proxy-settings", (Throwable)e);
                    errorLabel.setVisible(true);
                }
            }

            @Override
            public void resetValues() {
                super.resetValues();
                successLabel.setVisible(false);
                errorLabel.setVisible(false);
            }
        };
        content.addComponents(new Component[]{proxyConfigurationForm, successLabel, errorLabel, labelDescription});
        this.root.addComponent((Component)content);
        this.root.setExpandRatio((Component)content, 1.0f);
    }

    public void cleanupValues() {
        PackageManagerConfiguration configuration = (PackageManagerConfiguration)this.managerHome.getConfiguration(PackageManagerConfiguration.class);
        NetworkConfiguration.ProxyConfiguration proxyConfiguration = configuration.getProxyConfiguration();
        if (!proxyConfiguration.isEnabled()) {
            proxyConfiguration.setHost(null);
            proxyConfiguration.setPort(0);
            proxyConfiguration.setUser(null);
            proxyConfiguration.setPassword(null);
        }
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
    }
}

