/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractDirectoryObjectView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.model.ItemConfiguration;
import org.openthinclient.web.thinclient.presenter.DirectoryObjectPanelPresenter;
import org.openthinclient.web.thinclient.property.OtcProperty;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThinclientGroupView<T extends DirectoryObject>
extends AbstractDirectoryObjectView<T> {
    private final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected abstract String getSubtitle();

    public void saveValues(DirectoryObjectPanelPresenter profilePanelPresenter, T profile) {
        this.LOGGER.info("Save values for group: " + profile);
        profilePanelPresenter.getItemGroupPanels().forEach(itemGroupPanel -> itemGroupPanel.propertyComponents().stream().map(propertyComponent -> (OtcProperty)propertyComponent.getBinder().getBean()).collect(Collectors.toList()).forEach(otcProperty -> {
            String current;
            ItemConfiguration bean = otcProperty.getConfiguration();
            String propertyKey = otcProperty.getKey();
            String org = null;
            if (propertyKey.equals("name")) {
                org = profile.getName();
            } else if (propertyKey.equals("description")) {
                org = profile.getDescription();
            } else {
                this.LOGGER.warn("Unexpected key {} for group {} will be ignored!", (Object)propertyKey, (Object)profile.getClass().getName());
            }
            String string = current = bean.getValue() == null || bean.getValue().length() == 0 ? null : bean.getValue();
            if (current != null && !StringUtils.equals((CharSequence)org, (CharSequence)current)) {
                switch (propertyKey) {
                    case "name": {
                        profile.setName(current);
                        break;
                    }
                    case "description": {
                        profile.setDescription(current);
                    }
                }
            } else if (propertyKey.equals("description")) {
                this.LOGGER.info(" Apply null value for description");
                profile.setDescription(null);
            }
        }));
        boolean success = this.saveProfile(profile, profilePanelPresenter);
        if (success) {
            this.selectItem((DirectoryObject)profile);
            this.navigateTo((DirectoryObject)profile);
        }
    }

    @Override
    public void showProfileMetadata(T directoryObject) {
        this.showProfileMetadataPanel(this.createProfilePanel(directoryObject, true));
    }

    @Override
    public ProfilePanel createProfilePanel(T directoryObject) {
        return this.createProfilePanel(directoryObject, false);
    }

    public ProfilePanel createProfilePanel(T directoryObject, boolean isNew) {
        String title = isNew ? this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_NEW_GROUP_HEADER, new Object[0]) : directoryObject.getName();
        String subtitle = isNew ? "" : this.getSubtitle();
        ProfilePanel profilePanel = new ProfilePanel(title, subtitle, directoryObject.getClass());
        DirectoryObjectPanelPresenter presenter = new DirectoryObjectPanelPresenter(this, profilePanel, (DirectoryObject)directoryObject);
        OtcPropertyGroup propertyGroup = this.createMetadataPropertyGroup((DirectoryObject)directoryObject, isNew);
        presenter.setItemGroups(Arrays.asList(propertyGroup, new OtcPropertyGroup()));
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, directoryObject));
        if (isNew) {
            presenter.hideCopyButton();
            presenter.hideDeleteButton();
        }
        return profilePanel;
    }

    protected OtcPropertyGroup createMetadataPropertyGroup(DirectoryObject directoryObject, boolean isNew) {
        OtcPropertyGroup group = this.builder.createDirectoryObjectMetaDataGroup(directoryObject);
        if (isNew) {
            this.addProfileNameAlreadyExistsValidator(group);
        }
        return group;
    }
}

