/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import com.vaadin.spring.annotation.SpringView;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.common.model.service.ApplicationGroupService;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.UserGroupService;
import org.openthinclient.common.model.service.UserService;
import org.openthinclient.web.Audit;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientGroupView;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="applicationgroup_view", ui={ManagerUI.class})
@ThemeIcon(value="icon/applicationgroup-white.svg")
public final class ApplicationGroupView
extends AbstractThinclientGroupView<ApplicationGroup> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationGroupView.class);
    public static final String NAME = "applicationgroup_view";
    public static final String ICON = "icon/applicationgroup-white.svg";
    public static final ConsoleWebMessages TITLE_KEY = ConsoleWebMessages.UI_APPLICATIONGROUP_HEADER;
    @Autowired
    private ClientService clientService;
    @Autowired
    private ApplicationGroupService applicationGroupService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserGroupService userGroupService;

    @PostConstruct
    public void setup() {
        this.addStyleName("application_view");
    }

    @Override
    protected String getSubtitle() {
        return this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATIONGROUP, new Object[0]);
    }

    @Override
    public Set<ApplicationGroup> getAllItems() {
        return this.applicationGroupService.findAll();
    }

    @Override
    protected Class<ApplicationGroup> getItemClass() {
        return ApplicationGroup.class;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(ApplicationGroup applicationGroup) {
        Set members = applicationGroup.getMembers();
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(ApplicationGroup.class);
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        Set allApplications = this.applicationService.findAll();
        refPresenter.showReference(applicationGroup.getApplications(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATION_HEADER, new Object[0]), allApplications, values -> this.saveApplicationGroupReference(applicationGroup, (List<Item>)values));
        Set allUsers = this.userService.findAll();
        this.getRealmService().findAllRealms().forEach(realm -> allUsers.removeAll(realm.getAdministrators().getMembers()));
        refPresenter.showReference((Collection<? extends DirectoryObject>)members, User.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_USER_HEADER, new Object[0]), allUsers, values -> this.saveReference(applicationGroup, (List<Item>)values, allUsers, User.class));
        Set allUserGroups = this.userGroupService.findAll();
        refPresenter.showReference((Collection<? extends DirectoryObject>)members, UserGroup.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERGROUP_HEADER, new Object[0]), allUserGroups, values -> this.saveReference(applicationGroup, (List<Item>)values, allUserGroups, UserGroup.class));
        Set allClients = this.clientService.findAllClientMetaData();
        refPresenter.showReference((Collection<? extends DirectoryObject>)members, Client.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENT_HEADER, new Object[0]), allClients, values -> this.saveReference(applicationGroup, (List<Item>)values, allClients, Client.class));
        return referencesPanel;
    }

    private void saveApplicationGroupReference(ApplicationGroup applicationGroup, List<Item> values) {
        List<Application> oldValues = this.applicationService.findAll().stream().filter(application -> application.getMembers().contains(applicationGroup)).collect(Collectors.toList());
        LOGGER.debug(applicationGroup.getName() + " applications: {}", oldValues);
        oldValues.forEach(oldItem -> {
            if (values.stream().anyMatch(a -> a.getName().equals(oldItem.getName()))) {
                LOGGER.info("Keep oldValue as member: " + oldItem);
            } else {
                LOGGER.info("Remove oldValue from applicationGroup: " + oldItem);
                if (oldItem.getMembers().contains(applicationGroup)) {
                    oldItem.getMembers().remove(applicationGroup);
                    this.applicationService.save((DirectoryObject)oldItem);
                } else {
                    LOGGER.info("ApplicationGroup (to remove) not found in members of " + oldItem);
                }
            }
        });
        values.forEach(newValue -> {
            Application application = (Application)this.applicationService.findByName(newValue.getName());
            if (application != null) {
                if (!oldValues.contains(application)) {
                    LOGGER.info("Add ApplicationGroup to members of: " + newValue);
                    applicationGroup.getApplications().add(application);
                    application.getMembers().add(applicationGroup);
                    this.applicationService.save((DirectoryObject)application);
                }
            } else {
                LOGGER.info("Application not found for " + newValue);
            }
        });
    }

    @Override
    protected ApplicationGroup newProfile() {
        return new ApplicationGroup();
    }

    @Override
    public ApplicationGroup getFreshProfile(String name) {
        return (ApplicationGroup)this.applicationGroupService.findByName(name);
    }

    @Override
    protected <D extends DirectoryObject> Set<D> getMembers(ApplicationGroup profile, Class<D> clazz) {
        if (clazz == Application.class) {
            return profile.getApplications();
        }
        return profile.getMembers();
    }

    @Override
    public void save(ApplicationGroup profile) {
        LOGGER.info("Save: " + profile);
        this.applicationGroupService.save((DirectoryObject)profile);
        Audit.logSave((DirectoryObject)profile);
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public String getParentViewName() {
        return "application_view";
    }

    @Override
    public ConsoleWebMessages getViewTitleKey() {
        return TITLE_KEY;
    }
}

