/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import com.vaadin.spring.annotation.SpringView;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.DeviceService;
import org.openthinclient.common.model.service.HardwareTypeService;
import org.openthinclient.web.Audit;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractDirectoryObjectView;
import org.openthinclient.web.thinclient.AbstractProfileView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.ProfilePanelPresenter;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="device_view", ui={ManagerUI.class})
@SideBarItem(sectionId="client-management", captionCode="UI_DEVICE_HEADER", order=50)
@ThemeIcon(value="icon/device.svg")
public final class DeviceView
extends AbstractProfileView<Device> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceView.class);
    public static final String NAME = "device_view";
    public static final String ICON = "icon/device.svg";
    public static final ConsoleWebMessages TITLE_KEY = ConsoleWebMessages.UI_DEVICE_HEADER;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private HardwareTypeService hardwareTypeService;
    @Autowired
    private ClientService clientService;
    private ProfilePropertiesBuilder builder = new ProfilePropertiesBuilder();

    @PostConstruct
    private void setup() {
        this.addStyleName(NAME);
    }

    @Override
    public Set<Device> getAllItems() {
        try {
            return this.deviceService.findAll();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot find directory-objects: " + e.getMessage());
            this.showError(e);
            return Collections.emptySet();
        }
    }

    @Override
    protected Class<Device> getItemClass() {
        return Device.class;
    }

    @Override
    public ProfilePanel createProfilePanel(Device profile) throws BuildProfileException {
        Map<String, String> schemaNames = this.getSchemaNames();
        List<OtcPropertyGroup> otcPropertyGroups = this.builder.getOtcPropertyGroups(schemaNames, (Profile)profile);
        OtcPropertyGroup meta = otcPropertyGroups.get(0);
        this.addProfileNameAlreadyExistsValidator(meta);
        String type = meta.getProperty("type").get().getConfiguration().getValue();
        ProfilePanel profilePanel = new ProfilePanel(profile.getName(), schemaNames.getOrDefault(type, type), Device.class);
        ProfilePanelPresenter presenter = new ProfilePanelPresenter((AbstractDirectoryObjectView)this, profilePanel, (Profile)profile);
        presenter.setItemGroups(otcPropertyGroups);
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, profile));
        return profilePanel;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(Device device) {
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(Device.class);
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        Set members = device.getMembers();
        Set allHwTypes = this.hardwareTypeService.findAll();
        refPresenter.showReference((Collection<? extends DirectoryObject>)members, HardwareType.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_HWTYPE_HEADER, new Object[0]), allHwTypes, values -> this.saveReference(device, (List<Item>)values, allHwTypes, HardwareType.class));
        Set allClients = this.clientService.findAllClientMetaData();
        refPresenter.showReference((Collection<? extends DirectoryObject>)members, Client.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENT_HEADER, new Object[0]), allClients, values -> this.saveReference(device, (List<Item>)values, allClients, Client.class));
        return referencesPanel;
    }

    @Override
    protected Device newProfile() {
        return new Device();
    }

    @Override
    public Device getFreshProfile(String name) {
        return (Device)this.deviceService.findByName(name);
    }

    @Override
    protected <D extends DirectoryObject> Set<D> getMembers(Device profile, Class<D> clazz) {
        return profile.getMembers();
    }

    @Override
    public void save(Device profile) {
        LOGGER.info("Save: " + profile);
        this.deviceService.save((DirectoryObject)profile);
        Audit.logSave((DirectoryObject)profile);
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public ConsoleWebMessages getViewTitleKey() {
        return TITLE_KEY;
    }
}

