/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.Validator;
import com.vaadin.data.validator.RegexpValidator;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.ui.UI;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.ClientGroup;
import org.openthinclient.common.model.ClientMetaData;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.common.model.schema.ChoiceNode;
import org.openthinclient.common.model.schema.EntryNode;
import org.openthinclient.common.model.schema.GroupNode;
import org.openthinclient.common.model.schema.Node;
import org.openthinclient.common.model.schema.PasswordNode;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.SectionNode;
import org.openthinclient.common.model.schema.provider.SchemaLoadingException;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.model.ItemConfiguration;
import org.openthinclient.web.thinclient.model.SelectOption;
import org.openthinclient.web.thinclient.property.OtcOptionProperty;
import org.openthinclient.web.thinclient.property.OtcPasswordProperty;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.thinclient.property.OtcTextProperty;
import org.openthinclient.web.thinclient.util.ContextInfoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilePropertiesBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfilePropertiesBuilder.class);
    IMessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());

    public List<OtcPropertyGroup> getOtcPropertyGroups(Map<String, String> schemaNames, Profile profile) throws BuildProfileException {
        List<OtcPropertyGroup> propertyGroups = this.createPropertyStructure(profile);
        this.bindModel2Properties(profile, propertyGroups);
        propertyGroups.add(0, this.createProfileMetaDataGroup(schemaNames, profile));
        return propertyGroups;
    }

    private void bindModel2Properties(Profile profile, List<OtcPropertyGroup> propertyGroups) {
        propertyGroups.forEach(otcPropertyGroup -> {
            otcPropertyGroup.getOtcProperties().forEach(otcProperty -> {
                String profileValue = profile.getValueLocal(otcProperty.getKey());
                ItemConfiguration ic = new ItemConfiguration(otcProperty.getKey(), profileValue);
                otcProperty.setConfiguration(ic);
            });
            this.bindModel2Properties(profile, otcPropertyGroup.getGroups());
        });
    }

    private List<OtcPropertyGroup> createPropertyStructure(Profile profile) throws BuildProfileException {
        ArrayList<OtcPropertyGroup> properties = new ArrayList<OtcPropertyGroup>();
        Schema schema = null;
        try {
            schema = profile.getSchema(profile.getRealm());
            OtcPropertyGroup group = new OtcPropertyGroup();
            schema.getChildren().forEach(node -> this.extractChildren((Node)node, group, profile));
            properties.add(group);
        }
        catch (SchemaLoadingException e) {
            throw new BuildProfileException(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENTS_SCHEMA_NOT_LOADED, new Object[]{profile.getName()}), (Exception)((Object)e));
        }
        catch (Exception e) {
            if (schema == null) {
                throw new BuildProfileException(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENTS_SCHEMA_NOT_LOADED, new Object[]{profile.getName()}), e);
            }
            throw new BuildProfileException(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENTS_UNEXPECTED_ERROR, new Object[]{e.getMessage()}), e);
        }
        return properties;
    }

    private void extractChildren(Node node, OtcPropertyGroup group, Profile profile) {
        if (node instanceof SectionNode && "invisibleObjects".equals(node.getName())) {
            return;
        }
        String currentValue = profile.getValueLocal(node.getKey());
        if (node instanceof ChoiceNode) {
            group.addProperty(new OtcOptionProperty(node.getLabel(), ContextInfoUtil.prepareTip(node.getTip(), node.getKBArticle()), node.getKey(), currentValue, ((ChoiceNode)node).getValue(), ((ChoiceNode)node).getOptions().stream().map(o -> new SelectOption(o.getLabel(), o.getValue())).collect(Collectors.toList())));
        } else if (node instanceof PasswordNode) {
            group.addProperty(new OtcPasswordProperty(node.getLabel(), ContextInfoUtil.prepareTip(node.getTip(), node.getKBArticle()), node.getKey(), ((EntryNode)node).getValue()));
        } else if (node instanceof EntryNode) {
            group.addProperty(new OtcTextProperty(node.getLabel(), ContextInfoUtil.prepareTip(node.getTip(), node.getKBArticle()), node.getKey(), currentValue, ((EntryNode)node).getValue()));
        } else if (node instanceof GroupNode || node instanceof SectionNode) {
            OtcPropertyGroup group1 = new OtcPropertyGroup(node.getLabelOrNull(), ContextInfoUtil.prepareTip(node.getTip(), node.getKBArticle()));
            node.getChildren().forEach(n -> this.extractChildren((Node)n, group1, profile));
            group.addGroup(group1);
        }
    }

    public OtcPropertyGroup createDirectoryObjectMetaDataGroup(DirectoryObject directoryObject) {
        OtcPropertyGroup group = new OtcPropertyGroup();
        OtcTextProperty property = new OtcTextProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_NAME_LABEL, new Object[0]), null, "name", directoryObject.getName(), directoryObject.getName(), null);
        property.getConfiguration().addValidator((Validator)new StringLengthValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_NAME_VALIDATOR, new Object[0]), Integer.valueOf(1), null));
        property.getConfiguration().addValidator((Validator)new RegexpValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_NAME_REGEXP, new Object[0]), "[^ #].*"));
        property.getConfiguration().addValidator((Validator)new RegexpValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_NAME_REGEXP, new Object[0]), "[a-zA-Z0-9 {}\\[\\]()#.:*&`'~|?@$\\^%_-]+"));
        property.getConfiguration().addValidator((Validator)new RegexpValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_NAME_REGEXP, new Object[0]), ".*[^ #]"));
        group.addProperty(property);
        group.addProperty(new OtcTextProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_DESCRIPTION_LABEL, new Object[0]), null, "description", directoryObject.getDescription(), directoryObject.getDescription(), null));
        return group;
    }

    public OtcPropertyGroup createProfileMetaDataGroup(Map<String, String> schemaNames, Profile profile) {
        OtcPropertyGroup group = this.createDirectoryObjectMetaDataGroup((DirectoryObject)profile);
        String schemaName = null;
        if (profile.getRealm() != null) {
            schemaName = profile.getSchema(profile.getRealm()).getName();
        }
        Collator collator = Collator.getInstance();
        List<SelectOption> selectOptions = schemaNames.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue, collator)).map(entry -> new SelectOption((String)entry.getValue(), (String)entry.getKey())).collect(Collectors.toList());
        OtcOptionProperty optionProperty = new OtcOptionProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_TYPE_LABEL, new Object[0]), null, "type", schemaName != null ? schemaName : (selectOptions.size() == 1 ? selectOptions.get(0).getValue() : null), null, selectOptions);
        ItemConfiguration itemConfiguration = new ItemConfiguration(profile.getClass().getSimpleName().toLowerCase(), schemaName);
        itemConfiguration.disable();
        optionProperty.setConfiguration(itemConfiguration);
        group.addProperty(optionProperty);
        return group;
    }

    public static List<Item> createItems(Collection<? extends DirectoryObject> directoryObjects) {
        return directoryObjects.stream().map(directoryObject -> new Item(directoryObject.getName(), ProfilePropertiesBuilder.getType(directoryObject.getClass()))).collect(Collectors.toList());
    }

    public static List<Item> createFilteredItemsFromDO(Collection<? extends DirectoryObject> members, Class<?> clazz) {
        if (members == null) {
            return new ArrayList<Item>();
        }
        return members.stream().filter(member -> member.getClass() == clazz).map(member -> new Item(member.getName(), ProfilePropertiesBuilder.getType(member.getClass()))).collect(Collectors.toList());
    }

    public static List<? extends DirectoryObject> createGroupedItems(Set<? extends DirectoryObject> directoryObjects) {
        HashMap map = new HashMap();
        for (DirectoryObject directoryObject : directoryObjects) {
            String schemaName = "Misc";
            if (directoryObject instanceof Profile) {
                Profile profile = (Profile)directoryObject;
                try {
                    Schema schema = profile.getSchema(profile.getRealm());
                    schemaName = schema.getLabel();
                }
                catch (Exception e) {
                    LOGGER.warn("Profile-list-grouping broken: cannot load schema for " + profile, (Throwable)e);
                }
            }
            if (!map.containsKey(schemaName)) {
                map.put(schemaName, new ArrayList());
            }
            ((List)map.get(schemaName)).add(directoryObject);
        }
        Map result = map.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        ArrayList<MenuGroupProfile> arrayList = new ArrayList<MenuGroupProfile>();
        for (Map.Entry entry : result.entrySet()) {
            arrayList.add(new MenuGroupProfile((String)entry.getKey()));
            ((List)entry.getValue()).sort(Comparator.comparing(DirectoryObject::getName, String::compareToIgnoreCase));
            arrayList.addAll((Collection)entry.getValue());
        }
        if (map.size() == 1) {
            arrayList.remove(0);
        }
        return arrayList;
    }

    private static Item.Type getType(Class<? extends DirectoryObject> clazz) {
        Item.Type itemType;
        if (clazz.equals(Client.class) || clazz.equals(ClientMetaData.class)) {
            itemType = Item.Type.CLIENT;
        } else if (clazz.equals(Application.class)) {
            itemType = Item.Type.APPLICATION;
        } else if (clazz.equals(HardwareType.class)) {
            itemType = Item.Type.HARDWARETYPE;
        } else if (clazz.equals(Location.class)) {
            itemType = Item.Type.LOCATION;
        } else if (clazz.equals(Device.class)) {
            itemType = Item.Type.DEVICE;
        } else if (clazz.equals(ApplicationGroup.class)) {
            itemType = Item.Type.APPLICATIONGROUP;
        } else if (clazz.equals(UserGroup.class)) {
            itemType = Item.Type.USERGROUP;
        } else if (clazz.equals(ClientGroup.class)) {
            itemType = Item.Type.CLIENTGROUP;
        } else if (clazz.equals(User.class)) {
            itemType = Item.Type.USER;
        } else if (clazz.equals(Printer.class)) {
            itemType = Item.Type.PRINTER;
        } else {
            throw new RuntimeException("ProfileObject class not mapped to item.Type: " + clazz);
        }
        return itemType;
    }

    public static class MenuGroupProfile
    extends Profile {
        public MenuGroupProfile(String name) {
            this.setName(name);
        }
    }
}

