/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import com.vaadin.spring.annotation.SpringView;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.common.model.service.ApplicationGroupService;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.PrinterService;
import org.openthinclient.common.model.service.UserGroupService;
import org.openthinclient.common.model.service.UserService;
import org.openthinclient.web.Audit;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientGroupView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@SpringView(name="usergroup_view", ui={ManagerUI.class})
public final class UserGroupView
extends AbstractThinclientGroupView<UserGroup> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserGroupView.class);
    public static final String NAME = "usergroup_view";
    public static final String ICON = "icon/applicationgroup-white.svg";
    public static final ConsoleWebMessages TITLE_KEY = ConsoleWebMessages.UI_USERGROUP_HEADER;
    @Autowired
    private ApplicationGroupService applicationGroupService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private PrinterService printerService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserGroupService userGroupService;
    private boolean secondaryDirectory = false;

    @PostConstruct
    public void setup() {
        this.secondaryDirectory = "secondary".equals(this.getRealmService().getDefaultRealm().getValue("UserGroupSettings.DirectoryVersion"));
        this.addStyleName("user_view");
    }

    @Override
    protected String getSubtitle() {
        return this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERGROUP, new Object[0]);
    }

    @Override
    public Set<UserGroup> getAllItems() {
        return this.userGroupService.findAll();
    }

    @Override
    protected Class<UserGroup> getItemClass() {
        return UserGroup.class;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(UserGroup userGroup) {
        Set members = userGroup.getMembers();
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(UserGroup.class);
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        Set allUsers = this.userService.findAll();
        this.getRealmService().findAllRealms().forEach(realm -> allUsers.removeAll(realm.getAdministrators().getMembers()));
        Consumer<List<Item>> profileReferenceChangeConsumer = null;
        if (!this.secondaryDirectory) {
            profileReferenceChangeConsumer = values -> this.saveReference(userGroup, (List<Item>)values, allUsers, User.class);
        }
        refPresenter.showReference((Collection<? extends DirectoryObject>)members, User.class, this.mc.getMessage((Enum)ConsoleWebMessages.UI_USER_HEADER, new Object[0]), allUsers, profileReferenceChangeConsumer);
        Set allApplications = this.applicationService.findAll();
        refPresenter.showReference(userGroup.getApplications(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATION_HEADER, new Object[0]), allApplications, values -> this.saveReference(userGroup, (List<Item>)values, allApplications, Application.class));
        Set allApplicationGroups = this.applicationGroupService.findAll();
        refPresenter.showReference((Collection<? extends DirectoryObject>)userGroup.getApplicationGroups(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATIONGROUP_HEADER, new Object[0]), allApplicationGroups, values -> this.saveReference(userGroup, (List<Item>)values, allApplicationGroups, ApplicationGroup.class), this.getApplicationsForApplicationGroupFunction(userGroup));
        Set allPrinters = this.printerService.findAll();
        refPresenter.showReference(userGroup.getPrinters(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_PRINTER_HEADER, new Object[0]), allPrinters, values -> this.saveReference(userGroup, (List<Item>)values, allPrinters, Printer.class));
        return referencesPanel;
    }

    private Function<Item, List<Item>> getApplicationsForApplicationGroupFunction(UserGroup userGroup) {
        return item -> userGroup.getApplicationGroups().stream().filter(group -> group.getName().equals(item.getName())).findFirst().map(group -> ProfilePropertiesBuilder.createItems(group.getApplications())).orElse(Collections.emptyList());
    }

    @Override
    protected OtcPropertyGroup createMetadataPropertyGroup(DirectoryObject directoryObject, boolean isNew) {
        OtcPropertyGroup group = super.createMetadataPropertyGroup(directoryObject, isNew);
        if (this.secondaryDirectory) {
            group.getOtcProperties().forEach(p -> p.getConfiguration().disable());
        }
        return group;
    }

    @Override
    public ProfilePanel createProfilePanel(UserGroup profile, boolean isNew) {
        return super.createProfilePanel(profile, isNew || this.secondaryDirectory);
    }

    @Override
    protected UserGroup newProfile() {
        return new UserGroup();
    }

    @Override
    public UserGroup getFreshProfile(String name) {
        return (UserGroup)this.userGroupService.findByName(name);
    }

    @Override
    protected <D extends DirectoryObject> Set<D> getMembers(UserGroup profile, Class<D> clazz) {
        if (clazz == User.class) {
            return profile.getMembers();
        }
        if (clazz == ApplicationGroup.class) {
            return profile.getApplicationGroups();
        }
        if (clazz == Application.class) {
            return profile.getApplications();
        }
        if (clazz == Printer.class) {
            return profile.getPrinters();
        }
        return Collections.emptySet();
    }

    @Override
    public void save(UserGroup profile) {
        LOGGER.info("Save: " + profile);
        this.userGroupService.save((DirectoryObject)profile);
        Audit.logSave((DirectoryObject)profile);
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public String getParentViewName() {
        return "user_view";
    }

    @Override
    public ConsoleWebMessages getViewTitleKey() {
        return TITLE_KEY;
    }
}

