/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.openthinclient.web.thinclient.model.ItemConfiguration;

public class Item {
    private String name;
    private String description;
    private Type type;
    private List<ItemConfiguration> configuration = new ArrayList<ItemConfiguration>();

    public Item(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public List<ItemConfiguration> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(List<ItemConfiguration> configuration) {
        this.configuration = configuration;
    }

    public void addConfig(ItemConfiguration configuration) {
        configuration.setItem(this);
        this.configuration.add(configuration);
    }

    public ItemConfiguration getConfiguration(String key) {
        return this.configuration.stream().filter(ic -> ic.getKey().equals(key)).findAny().orElse(new ItemConfiguration(key, null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return Objects.equals(this.name, item.name) && Objects.equals(this.description, item.description) && this.type == item.type && Objects.equals(this.configuration, item.configuration);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.type, this.configuration});
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.name).append("type", (Object)this.type).append("conf", this.configuration).toString();
    }

    public static enum Type {
        DEVICE,
        APPLICATION,
        APPLICATIONGROUP,
        HARDWARETYPE,
        LOCATION,
        CLIENT,
        CLIENTGROUP,
        USER,
        USERGROUP,
        PRINTER;

    }
}

