/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.presenter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.ReferencesComponentPresenter;

public class ReferencePanelPresenter {
    private ProfileReferencesPanel view;

    public ReferencePanelPresenter(ProfileReferencesPanel view) {
        this.view = view;
    }

    public void showReference(Collection<? extends DirectoryObject> members, String title) {
        this.showReference(members, title, Collections.emptySet(), null, null, true);
    }

    public void showReferenceAddendum(Collection<? extends DirectoryObject> members, String title) {
        this.showReference(members, title, Collections.emptySet(), null, null, false);
    }

    public void showReferenceAddendum(Collection<? extends DirectoryObject> members, String title, Function<Item, List<Item>> memberSupplier) {
        this.showReference(members, title, Collections.emptySet(), null, memberSupplier, false);
    }

    public void showReference(Collection<? extends DirectoryObject> members, String title, Set<? extends DirectoryObject> allObjects, Consumer<List<Item>> profileReferenceChangeConsumer) {
        this.showReference(members, title, allObjects, profileReferenceChangeConsumer, null, true);
    }

    public void showReference(Collection<? extends DirectoryObject> members, Class<? extends DirectoryObject> clazz, String title, Set<? extends DirectoryObject> allObjects, Consumer<List<Item>> profileReferenceChangeConsumer) {
        this.showReference(this.filterByClass(members, clazz), title, allObjects, profileReferenceChangeConsumer, null, true);
    }

    public void showReference(Collection<? extends DirectoryObject> members, Class<? extends DirectoryObject> clazz, String title, Set<? extends DirectoryObject> allObjects, Consumer<List<Item>> profileReferenceChangeConsumer, Function<Item, List<Item>> memberSupplier) {
        this.showReference(this.filterByClass(members, clazz), title, allObjects, profileReferenceChangeConsumer, null, true);
    }

    public void showReference(Collection<? extends DirectoryObject> members, String title, Set<? extends DirectoryObject> allObjects, Consumer<List<Item>> profileReferenceChangeConsumer, Function<Item, List<Item>> memberSupplier) {
        this.showReference(members, title, allObjects, profileReferenceChangeConsumer, memberSupplier, true);
    }

    public void showReference(Collection<? extends DirectoryObject> members, String title, Set<? extends DirectoryObject> allObjects, Consumer<List<Item>> profileReferenceChangeConsumer, Function<Item, List<Item>> memberSupplier, boolean isReferenceStart) {
        boolean isReadOnly = profileReferenceChangeConsumer == null;
        List<Item> memberItems = ProfilePropertiesBuilder.createItems(members);
        ReferencesComponentPresenter presenter = this.view.addReferences(title, ProfilePropertiesBuilder.createItems(allObjects), memberItems, memberSupplier, isReadOnly, isReferenceStart);
        presenter.setProfileReferenceChangedConsumer(profileReferenceChangeConsumer);
    }

    private Collection<? extends DirectoryObject> filterByClass(Collection<? extends DirectoryObject> members, Class<? extends DirectoryObject> clazz) {
        return members.stream().filter(clazz::isInstance).collect(Collectors.toSet());
    }
}

