/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.presenter;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.HasValue;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.data.provider.Query;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Grid;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openthinclient.web.component.Popup;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.component.ItemButtonComponent;
import org.openthinclient.web.thinclient.component.ReferencesComponent;
import org.openthinclient.web.thinclient.model.Item;

public class ReferencesComponentPresenter {
    private IMessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
    private ReferencesComponent view;
    private Consumer<List<Item>> profileReferenceChanged;
    ListDataProvider<Item> itemListDataProvider;
    private List<Item> currentReferencedItems;
    private Function<Item, List<Item>> memberSupplier;
    private CheckBox selectAll;
    private AllCheckBoxes allCheckBoxes;
    private boolean checkBoxesIgnoreValueChange = false;
    private boolean selectAllIgnoreValueChange = false;
    private Query<Item, SerializablePredicate<Item>> queryUnreferenced;
    private Query<Item, SerializablePredicate<Item>> queryReferenced;
    private Query<Item, SerializablePredicate<Item>> queryAll;

    public ReferencesComponentPresenter(ReferencesComponent view, List<Item> allItems, List<Item> referencedItems, Function<Item, List<Item>> memberSupplier, boolean isReadOnly) {
        this.view = view;
        this.currentReferencedItems = referencedItems;
        this.memberSupplier = memberSupplier;
        if (!isReadOnly) {
            this.view.getMultiSelectPopupBtn().addClickListener(this::handleMultiSelectPopup);
        }
        this.itemListDataProvider = new ListDataProvider(allItems);
        this.itemListDataProvider.setSortComparator(Comparator.comparing(Item::getName, String::compareToIgnoreCase)::compare);
        this.allCheckBoxes = new AllCheckBoxes();
        this.queryUnreferenced = new Query((SerializablePredicate & Serializable)item -> !this.currentReferencedItems.contains(item));
        this.queryReferenced = new Query((SerializablePredicate & Serializable)item -> this.currentReferencedItems.contains(item));
        this.queryAll = new Query();
        for (Item item2 : referencedItems) {
            this.addItemToView(item2);
            this.addMemberDetails(item2);
        }
    }

    private void addItemToView(Item item) {
        ItemButtonComponent button = this.view.addItemComponent(item);
        button.addClickListener((Button.ClickListener & Serializable)clickEvent -> this.itemsDeSelected(Arrays.asList(item)));
    }

    private void itemsSelected(List<Item> items) {
        this.currentReferencedItems.addAll(items);
        this.profileReferenceChanged.accept(this.currentReferencedItems);
        items.forEach(item -> {
            this.addItemToView((Item)item);
            this.addMemberDetails((Item)item);
        });
    }

    private void itemsDeSelected(List<Item> items) {
        this.currentReferencedItems.removeAll(items);
        this.profileReferenceChanged.accept(this.currentReferencedItems);
        items.forEach(item -> {
            this.view.removeItemComponent(item.getName());
            this.view.removeReferenceSublineComponent(item.getName());
        });
    }

    private void handleMultiSelectPopup(Button.ClickEvent event) {
        Popup multiSelectPopup = new Popup(ConsoleWebMessages.UI_COMMON_PLEASE_SELECT, "reference-popup");
        CssLayout filterLine = new CssLayout();
        filterLine.setStyleName("filterLine");
        TextField filter = new TextField();
        filter.setPlaceholder(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_SEARCHFIELD_INPUTPROMPT, new Object[0]));
        filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event1 -> {
            this.itemListDataProvider.setFilter(Item::getName, (SerializablePredicate & Serializable)s -> s.toLowerCase().contains(((String)event1.getValue()).toLowerCase()));
            this.updateSelectAll();
        });
        this.itemListDataProvider.clearFilters();
        filterLine.addComponent((Component)filter);
        multiSelectPopup.addContent(new Component[]{filterLine});
        this.selectAll = new CheckBox(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_SELECT_ALL, new Object[0]), false);
        this.selectAll.setStyleName("selectAll");
        this.selectAll.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (!this.selectAllIgnoreValueChange) {
                this.checkBoxesIgnoreValueChange = true;
                if (((Boolean)e.getValue()).booleanValue()) {
                    this.itemListDataProvider.fetch(this.queryUnreferenced).forEach(item -> this.allCheckBoxes.setValue((Item)item, true));
                    this.itemsSelected(this.itemListDataProvider.fetch(this.queryUnreferenced).collect(Collectors.toList()));
                } else {
                    this.itemListDataProvider.fetch(this.queryReferenced).forEach(item -> this.allCheckBoxes.setValue((Item)item, false));
                    this.itemsDeSelected(this.itemListDataProvider.fetch(this.queryReferenced).collect(Collectors.toList()));
                }
                this.checkBoxesIgnoreValueChange = false;
            }
        });
        this.updateSelectAll();
        multiSelectPopup.addContent(new Component[]{this.selectAll});
        CssLayout table = new CssLayout();
        table.setStyleName("table");
        Grid referencesGrid = new Grid();
        referencesGrid.setDataProvider(this.itemListDataProvider);
        referencesGrid.setSelectionMode(Grid.SelectionMode.NONE);
        referencesGrid.removeHeaderRow(0);
        referencesGrid.addComponentColumn(this::createItemCheckBox);
        referencesGrid.setBodyRowHeight(32.0);
        table.addComponent((Component)referencesGrid);
        multiSelectPopup.addContent(new Component[]{table});
        multiSelectPopup.open();
        filter.focus();
    }

    private void updateSelectAll() {
        this.selectAllIgnoreValueChange = true;
        if (this.itemListDataProvider.fetch(this.queryAll).findAny().isPresent()) {
            this.selectAll.setValue(Boolean.valueOf(this.itemListDataProvider.fetch(this.queryAll).allMatch(this.currentReferencedItems::contains)));
        } else {
            this.selectAll.setValue(Boolean.valueOf(false));
        }
        this.selectAllIgnoreValueChange = false;
    }

    private CheckBox createItemCheckBox(Item item) {
        CheckBox checkBox = new CheckBox(item.getName(), this.currentReferencedItems.contains(item));
        this.allCheckBoxes.add(item, checkBox);
        checkBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (!this.checkBoxesIgnoreValueChange) {
                Boolean value = (Boolean)e.getValue();
                if (value.booleanValue()) {
                    this.itemsSelected(Arrays.asList(item));
                } else {
                    this.itemsDeSelected(Arrays.asList(item));
                }
                this.updateSelectAll();
            }
        });
        return checkBox;
    }

    public void setProfileReferenceChangedConsumer(Consumer<List<Item>> consumer) {
        this.profileReferenceChanged = consumer;
    }

    protected void addMemberDetails(Item item) {
        if (this.memberSupplier != null) {
            List<Item> members = this.memberSupplier.apply(item);
            List<ItemButtonComponent> components = members.stream().map(member -> new ItemButtonComponent((Item)member)).collect(Collectors.toList());
            this.view.addReferenceSublineComponents(item.getName(), (Component[])components.toArray(new ItemButtonComponent[0]));
        }
    }

    private class AllCheckBoxes {
        private Map<Item, WeakReference<CheckBox>> map = new HashMap<Item, WeakReference<CheckBox>>();

        private AllCheckBoxes() {
        }

        private Optional<CheckBox> get(Item item) {
            return Optional.ofNullable(this.map.get(item)).map(Reference::get);
        }

        void add(Item item, CheckBox checkBox) {
            this.map.put(item, new WeakReference<CheckBox>(checkBox));
        }

        void setValue(Item item, boolean value) {
            this.get(item).ifPresent(checkBox -> checkBox.setValue(Boolean.valueOf(value)));
        }

        boolean getValue(Item item) {
            return this.get(item).map(CheckBox::getValue).orElse(false);
        }
    }
}

