/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.ui;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.kstruct.gethostname4j.Hostname;
import com.vaadin.annotations.Push;
import com.vaadin.annotations.Theme;
import com.vaadin.event.MouseEvents;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.navigator.ViewDisplay;
import com.vaadin.navigator.ViewProvider;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinSession;
import com.vaadin.shared.communication.PushMode;
import com.vaadin.spring.navigator.SpringViewProvider;
import com.vaadin.ui.AbstractOrderedLayout;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.JavaScript;
import com.vaadin.ui.Label;
import com.vaadin.ui.MenuBar;
import com.vaadin.ui.Panel;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.common.model.service.UserService;
import org.openthinclient.i18n.LocaleUtil;
import org.openthinclient.service.common.license.LicenseChangeEvent;
import org.openthinclient.service.common.license.LicenseManager;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.component.LicenseMessageBar;
import org.openthinclient.web.event.DashboardEvent;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.ui.AccessDeniedView;
import org.openthinclient.web.ui.UserProfileSubWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.events.annotation.EventBusListenerMethod;
import org.vaadin.spring.security.VaadinSecurity;

@Theme(value="openthinclient")
@Push(value=PushMode.MANUAL)
@com.vaadin.annotations.JavaScript(value={"vaadin://js/UIFunctions.js"})
public abstract class AbstractUI
extends UI
implements ViewDisplay {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractUI.class);
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    VaadinSecurity vaadinSecurity;
    @Autowired
    SpringViewProvider viewProvider;
    @Autowired
    SpringViewProvider springViewProvider;
    @Autowired
    private EventBus.SessionEventBus eventBus;
    @Autowired
    private RealmService realmService;
    @Autowired
    private ClientService clientService;
    @Autowired
    private UserService userService;
    @Autowired
    private LicenseManager licenseManager;
    @Value(value="${application.is-preview}")
    private boolean applicationIsPreview;
    private Panel springViewDisplay;
    protected IMessageConveyor mc;
    private AbstractOrderedLayout root;
    private UserProfileSubWindow userProfileWindow;
    private LicenseMessageBar licenseMessageBar;

    protected abstract OTCSideBar getSideBar();

    @PostConstruct
    public void init() {
        this.springViewProvider.setAccessDeniedViewClass(AccessDeniedView.class);
    }

    protected void init(VaadinRequest request) {
        this.setLocale(LocaleUtil.getLocaleForMessages(ConsoleWebMessages.class, (Locale)UI.getCurrent().getLocale()));
        Locale.setDefault(UI.getCurrent().getLocale());
        this.addStyleName("valo-menu-responsive");
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        Page.getCurrent().addBrowserWindowResizeListener((Page.BrowserWindowResizeListener & Serializable)event -> this.eventBus.publish((Object)this, (Object)new DashboardEvent.BrowserResizeEvent(event.getHeight(), event.getWidth())));
        Page.getCurrent().setTitle(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PAGE_TITLE, new Object[0]));
        this.licenseMessageBar = new LicenseMessageBar(this.licenseManager, this.clientService);
        this.showMainScreen();
        JavaScript.getCurrent().execute("installGridTooltips()");
        JavaScript.getCurrent().execute("installInfoButtonFunction()");
        this.addClickListener((MouseEvents.ClickListener & Serializable)e -> this.eventBus.publish((Object)e, (Object)new DashboardEvent.CloseOpenWindowsEvent()));
        this.userProfileWindow = new UserProfileSubWindow(this.userService);
    }

    protected void afterNavigatorViewChange(ViewChangeListener.ViewChangeEvent event) {
        JavaScript.getCurrent().execute("disableSpellcheck()");
        JavaScript.getCurrent().execute("installCopyOnClick()");
    }

    private void showMainScreen() {
        OTCSideBar sideBar = this.getSideBar();
        String logoFileName = this.applicationIsPreview ? "logo-beta.svg" : "logo.svg";
        Image image = new Image(null, (Resource)new ThemeResource(logoFileName));
        image.addClickListener((MouseEvents.ClickListener & Serializable)e -> UI.getCurrent().getPage().setLocation("/"));
        image.addStyleName("logo-button");
        image.removeStyleName("valo-menu-logo");
        sideBar.setLogo((Component)image);
        this.root = new HorizontalLayout();
        this.root.setSpacing(false);
        this.root.setSizeFull();
        sideBar.setId("mainmenu");
        this.root.addComponent((Component)sideBar);
        VerticalLayout vl = new VerticalLayout();
        vl.setSpacing(false);
        vl.setMargin(false);
        vl.setSizeFull();
        vl.addComponents(new Component[]{this.buildHeader(), this.licenseMessageBar});
        CssLayout content = new CssLayout();
        content.addStyleName("view-content");
        content.setSizeFull();
        vl.addComponent((Component)content);
        vl.setExpandRatio((Component)content, 1.0f);
        Navigator navigator = new Navigator(UI.getCurrent(), (ComponentContainer)content);
        navigator.addViewChangeListener(new ViewChangeListener(){

            public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
                return true;
            }

            public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
                AbstractUI.this.afterNavigatorViewChange(event);
            }
        });
        navigator.addProvider((ViewProvider)this.viewProvider);
        if (navigator.getState().isEmpty()) {
            navigator.navigateTo(this.getInitialView());
        } else {
            navigator.navigateTo(navigator.getState());
        }
        this.root.addComponents(new Component[]{vl});
        this.root.setExpandRatio((Component)vl, 1.0f);
        this.setContent((Component)this.root);
    }

    protected String getInitialView() {
        return "";
    }

    @EventBusListenerMethod
    public void licenseChange(LicenseChangeEvent ev) {
        this.updateLicenseBar();
    }

    @EventBusListenerMethod
    public void userCountChange(DashboardEvent.ClientCountChangeEvent ev) {
        this.updateLicenseBar();
    }

    private void updateLicenseBar() {
        if (this.licenseMessageBar != null) {
            this.licenseMessageBar.updateContent();
            this.push();
        }
    }

    public void attach() {
        super.attach();
        this.eventBus.subscribe((Object)this);
    }

    public void detach() {
        this.eventBus.unsubscribe((Object)this);
        super.detach();
    }

    protected abstract Component buildHeader();

    protected Component getRealmLabel() {
        Optional realm = this.realmService.findAllRealms().stream().findFirst();
        String description = realm.isPresent() ? ((Realm)realm.get()).getDescription() : "";
        String hostname = Hostname.getHostname();
        CssLayout realmLabel = new CssLayout();
        realmLabel.addStyleName("realm-label");
        realmLabel.addComponents(new Component[]{new Label(hostname), new Label(description)});
        return realmLabel;
    }

    protected Component buildLogoutButton() {
        UserDetails principal = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        MenuBar menuBar = new MenuBar();
        menuBar.addStyleName("small");
        menuBar.addStyleName("header-menu");
        MenuBar.MenuItem file = menuBar.addItem(principal.getUsername(), null);
        file.addItem(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE, new Object[0]), this::showProfileSubWindow);
        file.addItem(this.mc.getMessage((Enum)ConsoleWebMessages.UI_LOGOUT, new Object[0]), this::onLogoutButton);
        return menuBar;
    }

    private void onLogoutButton(MenuBar.MenuItem menuItem) {
        VaadinSession.getCurrent().close();
        this.vaadinSecurity.logout();
    }

    private void showProfileSubWindow(MenuBar.MenuItem menuItem) {
        if (!UI.getCurrent().getWindows().contains((Object)this.userProfileWindow)) {
            SecurityContext securityContext = (SecurityContext)VaadinSession.getCurrent().getSession().getAttribute("SPRING_SECURITY_CONTEXT");
            Authentication authentication = securityContext.getAuthentication();
            UserDetails principal = (UserDetails)authentication.getPrincipal();
            try {
                this.userProfileWindow.refresh((User)this.userService.findByName(principal.getUsername()));
            }
            catch (Exception e) {
                LOGGER.warn("Cannot find directory-object: " + e.getMessage());
                this.userProfileWindow.showError(e);
            }
            UI.getCurrent().addWindow((Window)this.userProfileWindow);
        } else {
            this.userProfileWindow.close();
            UI.getCurrent().removeWindow((Window)this.userProfileWindow);
        }
    }

    public void showView(View view) {
        if (this.springViewDisplay != null) {
            this.springViewDisplay.setContent((Component)view);
        }
    }
}

