/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.ui;

import com.vaadin.data.HasValue;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Page;
import com.vaadin.server.SerializableBiPredicate;
import com.vaadin.server.ThemeResource;
import com.vaadin.server.VaadinRequest;
import com.vaadin.shared.data.sort.SortDirection;
import com.vaadin.spring.annotation.SpringUI;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.IconGenerator;
import com.vaadin.ui.UI;
import com.vaadin.ui.UIDetachedException;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.ArrayList;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.ClientMetaData;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.DeviceService;
import org.openthinclient.common.model.service.HardwareTypeService;
import org.openthinclient.common.model.service.LocationService;
import org.openthinclient.common.model.service.PrinterService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.common.model.service.UserService;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.event.DashboardEvent;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.ui.AbstractUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.events.annotation.EventBusListenerMethod;

@SpringUI
public final class ManagerUI
extends AbstractUI
implements View {
    private static final long serialVersionUID = 4314279050575370517L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagerUI.class);
    public static final long REFRESH_DASHBOARD_MILLS = 10000L;
    @Autowired
    @Qualifier(value="deviceSideBar")
    OTCSideBar deviceSideBar;
    @Autowired
    private EventBus.SessionEventBus eventBus;
    @Autowired
    private RealmService realmService;
    @Autowired
    private PrinterService printerService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private DeviceService deviceService;
    @Autowired
    private HardwareTypeService hardwareTypeService;
    @Autowired
    private ClientService clientService;
    @Autowired
    private LocationService locationService;
    @Autowired
    private UserService userService;
    private ComboBox<DirectoryObject> searchTextField;
    private boolean runThread = true;

    @Override
    protected OTCSideBar getSideBar() {
        return this.deviceSideBar;
    }

    @Override
    protected void init(VaadinRequest request) {
        this.buildSearchTextField();
        super.init(request);
        Page.getCurrent().getStyles().add(String.format(".openthinclient {--no-results-feedback: \"%s\"}", this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_SEARCH_NO_RESULT, new Object[0])));
        new RefreshDashboardThread().start();
    }

    @Override
    protected void afterNavigatorViewChange(ViewChangeListener.ViewChangeEvent event) {
        this.searchTextField.setValue(null);
        if (event.getNavigator().getState() != null) {
            this.deviceSideBar.updateFilterGrid(event.getNewView(), event.getParameters());
        }
        super.afterNavigatorViewChange(event);
    }

    @EventBusListenerMethod
    public void closeOpenWindows(DashboardEvent.CloseOpenWindowsEvent event) {
        for (Window window : UI.getCurrent().getWindows()) {
            window.close();
            UI.getCurrent().removeWindow(window);
        }
    }

    @Override
    public void detach() {
        LOGGER.debug("Detach ManagerUI " + (Object)((Object)this) + " and stop Thread");
        this.runThread = false;
        super.detach();
    }

    @Override
    protected Component buildHeader() {
        CssLayout header = new CssLayout(new Component[]{this.getRealmLabel(), this.searchTextField, this.buildLogoutButton()});
        header.addStyleName("header");
        return header;
    }

    private void buildSearchTextField() {
        this.searchTextField = new ComboBox();
        this.searchTextField.addStyleName("header-searchfield");
        this.searchTextField.setEmptySelectionAllowed(false);
        this.searchTextField.setPopupWidth("300px");
        this.searchTextField.addValueChangeListener(this::onSearchSelect);
        this.searchTextField.setItemCaptionGenerator(DirectoryObject::getName);
        this.searchTextField.setItemIconGenerator((IconGenerator & Serializable)profile -> {
            String icon;
            if (profile instanceof Application) {
                icon = "icon/application.svg";
            } else if (profile instanceof ApplicationGroup) {
                icon = "icon/applicationgroup-white.svg";
            } else if (profile instanceof Printer) {
                icon = "icon/printer.svg";
            } else if (profile instanceof HardwareType) {
                icon = "icon/hardwaretype.svg";
            } else if (profile instanceof Device) {
                icon = "icon/device.svg";
            } else if (profile instanceof ClientMetaData) {
                icon = "icon/thinclient.svg";
            } else if (profile instanceof Location) {
                icon = "icon/location.svg";
            } else if (profile instanceof User) {
                icon = "icon/user.svg";
            } else {
                return null;
            }
            return new ThemeResource(icon);
        });
        new Thread(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                ArrayList<DirectoryObject> directoryObjects = new ArrayList<DirectoryObject>();
                try {
                    directoryObjects.addAll(ManagerUI.this.applicationService.findAll());
                    directoryObjects.addAll(ManagerUI.this.printerService.findAll());
                    directoryObjects.addAll(ManagerUI.this.deviceService.findAll());
                    directoryObjects.addAll(ManagerUI.this.hardwareTypeService.findAll());
                    directoryObjects.addAll(ManagerUI.this.locationService.findAll());
                    directoryObjects.addAll(ManagerUI.this.clientService.findAllClientMetaData());
                    directoryObjects.addAll(ManagerUI.this.userService.findAll());
                    ManagerUI.this.realmService.findAllRealms().forEach(realm -> directoryObjects.removeAll(realm.getAdministrators().getMembers()));
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot find clients for search: " + e.getMessage());
                }
                LOGGER.info("Setup directoryObjects-grid took " + (System.currentTimeMillis() - start) + "ms");
                ManagerUI.this.eventBus.publish((Object)this, (Object)new DashboardEvent.SearchObjectsSetupEvent(directoryObjects));
            }
        }.start();
    }

    @EventBusListenerMethod
    public void setupSearchObjects(DashboardEvent.SearchObjectsSetupEvent ev) {
        ListDataProvider dataProvider = DataProvider.ofCollection(ev.getDirectoryObjects());
        dataProvider.setSortOrder((ValueProvider & Serializable)source -> source.getName().toLowerCase(), SortDirection.ASCENDING);
        this.searchTextField.setDataProvider(dataProvider.filteringBy((SerializableBiPredicate & Serializable)(directoryObject, filterText) -> {
            String description;
            String value = filterText.toLowerCase();
            if (directoryObject.getName().toLowerCase().contains(value)) {
                return true;
            }
            if (directoryObject instanceof ClientMetaData) {
                ClientMetaData client = (ClientMetaData)directoryObject;
                String mac = client.getMacAddress();
                if (mac != null && (mac.contains(value) || mac.replace(":", "").contains(value))) {
                    return true;
                }
                String ip = client.getIpHostNumber();
                if (ip != null && ip.contains(value)) {
                    return true;
                }
            }
            return (description = directoryObject.getDescription()) != null && description.toLowerCase().contains(value);
        }));
    }

    private void onSearchSelect(HasValue.ValueChangeEvent<DirectoryObject> event) {
        DirectoryObject directoryObject = (DirectoryObject)event.getValue();
        String navigationState = null;
        if (directoryObject instanceof ApplicationGroup) {
            navigationState = "applicationgroup_view";
        } else if (directoryObject instanceof Application) {
            navigationState = "application_view";
        } else if (directoryObject instanceof ClientMetaData) {
            navigationState = "client_view";
        } else if (directoryObject instanceof Device) {
            navigationState = "device_view";
        } else if (directoryObject instanceof HardwareType) {
            navigationState = "hardwaretype_view";
        } else if (directoryObject instanceof Location) {
            navigationState = "location_view";
        } else if (directoryObject instanceof Printer) {
            navigationState = "printer_view";
        } else if (directoryObject instanceof User) {
            navigationState = "user_view";
        }
        if (navigationState != null) {
            this.getNavigator().navigateTo(navigationState + "/edit/" + directoryObject.getName());
        }
    }

    class RefreshDashboardThread
    extends Thread {
        RefreshDashboardThread() {
        }

        @Override
        public void run() {
            LOGGER.info("Refreshing Dashboard each {} seconds.", (Object)10L);
            ManagerUI ui = ManagerUI.this;
            try {
                while (ManagerUI.this.runThread) {
                    Thread.sleep(10000L);
                    if (ui.isAttached()) {
                        try {
                            ui.access(new Runnable(){

                                @Override
                                public void run() {
                                    ManagerUI.this.eventBus.publish((Object)this, (Object)new DashboardEvent.PXEClientListRefreshEvent(null));
                                }
                            });
                        }
                        catch (UIDetachedException e) {
                            LOGGER.info("UIDetachedException detected, ui class=" + (Object)((Object)ui));
                        }
                        continue;
                    }
                    LOGGER.debug((Object)((Object)ui) + " not attached.");
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Error while executing RefreshDashboardThread", (Throwable)e);
            }
        }
    }
}

