/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.name;

import java.io.Serializable;
import java.util.Arrays;
import javax.naming.InvalidNameException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeTypeAndValue
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger((Class)AttributeTypeAndValue.class);
    private String normType;
    private String upType;
    private Object value;
    private String upName;
    private int start;
    private int length;
    private static final boolean CASE_SENSITIVE = true;
    private static final boolean CASE_INSENSITIVE = false;
    private static final boolean[] DN_ESCAPED_CHARS = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};

    public AttributeTypeAndValue() {
        this.normType = null;
        this.upType = null;
        this.value = null;
        this.upName = "";
        this.start = -1;
        this.length = 0;
    }

    public AttributeTypeAndValue(String type, Object value) throws InvalidNameException {
        if (StringTools.isEmpty(type) || StringTools.isEmpty(type.trim())) {
            log.error("The type cannot be empty or null");
            throw new InvalidNameException("Null or empty type is not allowed");
        }
        this.normType = type.trim().toLowerCase();
        this.upType = type;
        this.value = value instanceof String ? (StringTools.isEmpty((String)value) ? "" : value) : value;
        this.upName = type + '=' + value;
        this.start = 0;
        this.length = this.upName.length();
    }

    public String getNormType() {
        return this.normType;
    }

    public String getUpType() {
        return this.upType;
    }

    public void setType(String type) throws InvalidNameException {
        if (StringTools.isEmpty(type) || StringTools.isEmpty(type.trim())) {
            log.error("The type cannot be empty or null");
            throw new InvalidNameException("The AttributeTypeAndValue type cannot be null or empty ");
        }
        this.normType = type.trim().toLowerCase();
        this.upType = type;
        this.upName = type + this.upName.substring(this.upName.indexOf(61));
        this.start = -1;
        this.length = this.upName.length();
    }

    public void setTypeNormalized(String type) throws InvalidNameException {
        if (StringTools.isEmpty(type) || StringTools.isEmpty(type.trim())) {
            log.error("The type cannot be empty or null");
            throw new InvalidNameException("The AttributeTypeAndValue type cannot be null or empty ");
        }
        this.normType = type.trim().toLowerCase();
        this.upType = type;
        this.upName = type + this.upName.substring(this.upName.indexOf(61));
        this.start = -1;
        this.length = this.upName.length();
    }

    public Object getValue() {
        return this.value;
    }

    public String getNormalizedValue() {
        return this.normalize();
    }

    public void setValue(Object value) {
        this.value = value instanceof String ? (StringTools.isEmpty((String)value) ? "" : (String)value) : value;
        this.upName = this.upName.substring(0, this.upName.indexOf(61) + 1) + value;
        this.start = -1;
        this.length = this.upName.length();
    }

    public int getLength() {
        return this.length;
    }

    public int getStart() {
        return this.start;
    }

    public String getUpName() {
        return this.upName;
    }

    public void setValueNormalized(String value) {
        String newValue = StringTools.trim(value);
        this.value = StringTools.isEmpty(newValue) ? "" : newValue;
        this.upName = this.upName.substring(0, this.upName.indexOf(61) + 1) + value;
        this.start = -1;
        this.length = this.upName.length();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new Error("Assertion failure");
        }
    }

    public int compareTo(Object object) {
        if (object instanceof AttributeTypeAndValue) {
            AttributeTypeAndValue nc = (AttributeTypeAndValue)object;
            int res = this.compareType(this.normType, nc.normType);
            if (res != 0) {
                return res;
            }
            return this.compareValue(this.value, nc.value, true);
        }
        return 1;
    }

    public int compareToIgnoreCase(Object object) {
        if (object instanceof AttributeTypeAndValue) {
            AttributeTypeAndValue nc = (AttributeTypeAndValue)object;
            int res = this.compareType(this.normType, nc.normType);
            if (res != 0) {
                return res;
            }
            return this.compareValue(this.value, nc.value, false);
        }
        return 1;
    }

    private int compareType(String val1, String val2) {
        if (StringTools.isEmpty(val1)) {
            return StringTools.isEmpty(val2) ? 0 : -1;
        }
        if (StringTools.isEmpty(val2)) {
            return 1;
        }
        return StringTools.trim(val1).compareToIgnoreCase(StringTools.trim(val2));
    }

    private int compareValue(Object val1, Object val2, boolean sensitivity) {
        if (val1 instanceof String) {
            if (val2 instanceof String) {
                int val;
                int n = val = sensitivity ? ((String)val1).compareTo((String)val2) : ((String)val1).compareToIgnoreCase((String)val2);
                return val < 0 ? -1 : (val > 0 ? 1 : val);
            }
            return 1;
        }
        if (val1 instanceof byte[]) {
            if (Arrays.equals((byte[])val1, (byte[])val2)) {
                return 0;
            }
            return 1;
        }
        return 1;
    }

    public String normalize() {
        if (this.value instanceof String) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.normType).append('=');
            String normalizedValue = (String)this.value;
            int valueLength = normalizedValue.length();
            if (normalizedValue.length() > 0) {
                for (int i = 0; i < valueLength; ++i) {
                    char c = normalizedValue.charAt(i);
                    if (c < '\u0000' || c > '\u0080') {
                        byte[] bb = StringTools.getBytesUtf8(normalizedValue.substring(i, i + 1));
                        for (int j = 0; j < bb.length; ++j) {
                            byte b = bb[j];
                            sb.append('\\').append(StringTools.dumpHex((byte)((b & 0xF0) >> 4))).append(StringTools.dumpHex(b));
                        }
                        continue;
                    }
                    if (DN_ESCAPED_CHARS[c]) {
                        if (c == ' ') {
                            if (i == 0 || i == valueLength - 1) {
                                sb.append('\\').append(c);
                                continue;
                            }
                            sb.append(' ');
                            continue;
                        }
                        if (c == '#') {
                            if (i == 0) {
                                sb.append("\\#");
                                continue;
                            }
                            sb.append('#');
                            continue;
                        }
                        sb.append('\\').append(c);
                        continue;
                    }
                    sb.append(c);
                }
            }
            return sb.toString();
        }
        return this.normType + "=#" + StringTools.dumpHexPairs((byte[])this.value);
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + (this.normType != null ? this.normType.hashCode() : 0);
        result = result * 37 + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (StringTools.isEmpty(this.normType) || StringTools.isEmpty(this.normType.trim())) {
            return "";
        }
        sb.append(this.normType).append("=");
        if (this.value != null) {
            sb.append(this.value);
        }
        return sb.toString();
    }
}

